/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wifistartup.h"
#include "iconadd2.h"

wifiStartup::wifiStartup(QWidget *parent, const char *name, QString scriptPath) : QDialog(parent, name, true)
{
    script = scriptPath;

    this->setFixedSize(500,300);
    this->setCaption(tr("WiFi-Setup startup"));

    headLine = new QLabel(tr("Start WiFi-Setup"),this,"headLine");
    headLine->setFont(QFont("Helvetic",18,QFont::Bold,true));
    headLine->setFrameStyle(QFrame::Panel||QFrame::Raised);

    scriptProcess = new QProcess(this);
    scriptOutput = new QMultiLineEdit(this,"scriptOutput");
    scriptOutput->setFont(QFont("Helvetic",10,QFont::Normal,false));
    scriptOutput->setFrameStyle(QFrame::Panel|QFrame::Sunken);
    QToolTip::add(scriptOutput,tr("Messages produced by the startup script"));

    debugLabel = new QLabel("Debug",this,"debugLabel");
    debugLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));

    doneButton = new QPushButton(QPixmap(done_xpm),tr("done"),this,"doneButton");
    doneButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(doneButton,tr("Close this window."));

    exportScriptButton = new QPushButton(QPixmap(export_xpm),tr("export Script"),this,"exportScriptButton");
    exportScriptButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(exportScriptButton,tr("Export the startup script for external use!"));

    startScriptButton = new QPushButton(QPixmap(startscript_xpm),tr("Start Script"),this,"startScriptButton");
    startScriptButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(startScriptButton,tr("Start the setup script to set up the wifi interface"));

    connect(scriptProcess,SIGNAL(readyReadStdout()),this,SLOT(slot_scriptProcessCanReadStdout()));
    connect(scriptProcess,SIGNAL(processExited()),this,SLOT(slot_scriptProcessExited()));
    connect(doneButton,SIGNAL(clicked()),this,SLOT(slot_doneButtonClicked()));
    connect(exportScriptButton,SIGNAL(clicked()),this,SLOT(slot_exportScriptButtonClicked()));
    connect(startScriptButton,SIGNAL(clicked()),this,SLOT(slot_startScriptButtonClicked()));

    initDialog();
}


wifiStartup::~wifiStartup()
{
}

void wifiStartup::initDialog(){
    headLine->setGeometry(5,2,this->width()-10,30);
    scriptOutput->setGeometry(5,35,this->width()-10,this->height()-80);
    debugLabel->setGeometry(this->width()-80,scriptOutput->y()-22,70,20);
    startScriptButton->setGeometry(5,this->height()-40,130,35);
    exportScriptButton->setGeometry(startScriptButton->x()+startScriptButton->width()+5,startScriptButton->y(),startScriptButton->width(),startScriptButton->height());
    doneButton->setGeometry(this->width()-exportScriptButton->width()-5,this->height()-40,exportScriptButton->width(),35);
}


void wifiStartup::slot_startScriptButtonClicked(){
    scriptOutput->setText("");
    doneButton->setEnabled(false);
    exportScriptButton->setEnabled(false);
    scriptOutput->setText(tr("Starting Script: ") + script + "\n\n");
    scriptProcess->clearArguments();
    scriptProcess->addArgument(script);
    scriptProcess->start();
}

void wifiStartup::slot_scriptProcessCanReadStdout(){
    QString output;
    output = scriptOutput->text();
    while (scriptProcess->canReadLineStdout()){
        output = output + scriptProcess->readLineStdout() + "\n";
    }

    scriptOutput->setText(output);

}

void wifiStartup::slot_scriptProcessExited(){
    QString output = scriptOutput->text();
    output = output + tr("\nDONE!");
    scriptOutput->setText(output);
    doneButton->setEnabled(true);
    exportScriptButton->setEnabled(true);
}

void wifiStartup::slot_doneButtonClicked(){
    this->done(0);
}

void wifiStartup::slot_exportScriptButtonClicked(){
int rc;
    QString s = QFileDialog::getExistingDirectory("/home",this,tr("get existing Directory"),tr("Choose a folder where to save" ));
    if (s != ""){
        rc = system("cp " + script + " " + s);
        rc == 0?QMessageBox::information(this,tr("Info"),tr("Script ") + script + tr(" saved at ") + s + " !"):QMessageBox::information(this,tr("Info"),("Saving of ") + script + tr(" failed!"));
    }
}
#include "wifistartup.moc"
