/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#define _DEBUG
#include "kndiswrapper.h"
#include <icons.h>

#include <kmainwindow.h>
#include <klocale.h>

kndiswrapper::kndiswrapper() : QWidget( 0, "kndiswrapper" )
{


    QString homePath=getenv("HOME");
    int rc;

    QString commentText = tr("KNDISWrapper will help you to setup your wireless network with ndiswrapper.\n\nThe Install Driver Button \
is used to install a new driver for a wireless dvice supported by ndiswrapper. To do so, you have to \
identify the appropriate '.inf' file. Sometimes you find this file on the driver-CD delivered together \
with the hardware. In some cases this file is stored in a '.cab' file. This is a Windows archive file \
and can be extracted with 'cabextract'. If the driver is delivered only in a '.exe' setup-file you can '\
only install the driver under Windows and look for the driver in the Windows Directory.\n\n\
The Remove Driver Button is used to remove a Windows driver that doesn't work or isn't used any longer.\n\
A copy of the driver is made so it can be restored if needed.\n\n\
With the Reload List Button the driver list is loaded again. Changes (e.g. hardware installed) are not detected \
automaticly.\n\nWith the Restore Driver Button you can re-install a driver, previously removed through the Remove Button\n\n\
Config Network invokes the network configuration dialog. Here you can setup the interface associated to the driver \
you have selected in the list.\n\n\
With the Quit Button you exit this application.");

    disabled=0;
    addDriver=1;
    delDriver=2;
    reloadList=4;
    restoreDriver=8;
    quit=16;
    hwList=32;
    netconf=64;

    disablerootcheck=false;
    disablenetconf=false;
    invokeSetup=false;
  if (qApp->argc() > 1){
    for (int i=0; i < qApp->argc();i++){
      if ((QString)qApp->argv()[i] == "--disablerootcheck") disablerootcheck=true;
      if ((QString)qApp->argv()[i] == "--setup") invokeSetup=true;
      if ((QString)qApp->argv()[i] == "--disablenetconf") disablenetconf=true;
    }
  }

    if (QFile::exists(homePath + "/.kndiswrapper") == false){
        rc = system("mkdir " + homePath + "/.kndiswrapper");
    }

    this->setFixedSize(700,340);

    comment = new QMultiLineEdit(this,"comment");
    comment->setText(commentText);
    comment->setFont(QFont("Helvetic",10,QFont::Normal,true));
    comment->setReadOnly(true);

    contextMenu = new QPopupMenu(this);
    contextMenu->insertItem(QPixmap(adddriver_xpm),tr("Add Driver"),this,SLOT(slot_addDriverButtonClicked()));
    contextMenu->insertItem(QPixmap(deldriver_xpm),tr("Remove Driver"),this,SLOT(slot_removeDriverButtonClicked()));
    contextMenu->insertSeparator();
    contextMenu->insertItem(QPixmap(reload_xpm),tr("Reload List"),this,SLOT(slot_reloadButtonClicked()));
    contextMenu->insertSeparator();
    contextMenu->insertItem(QPixmap(kndiswrapper_xpm),tr("Module Check"),this,SLOT(slot_moduleCheckRequested()));
    contextMenu->insertItem(QPixmap(info_xpm),tr("Info dmesg"),this,SLOT(slot_infoProcessRequested()));
    contextMenu->insertItem(QPixmap(wiki_xpm),tr("Offline Wiki"),this,SLOT(slot_wikiRequested()));

    if (!disablenetconf){
      contextMenu->insertSeparator();
      contextMenu->insertItem(QPixmap(confignetwork_xpm),tr("Config Network"),this,SLOT(slot_configNetworkRequested()));
    }

    hardwareList = new QTable(0,1,this,"hardwareList");
    hardwareList->setTopMargin(2);
    hardwareList->setLeftMargin(0);
    hardwareList->setReadOnly(true);
    QToolTip::add(hardwareList,tr("Right-Click for more options"));

    logoLabel = new QLabel("kndiswrapper",this,"logoLabel");
    logoLabel->setPixmap(QPixmap(kndiswrapper_logo_xpm));

    addDriverButton = new QPushButton(QPixmap(adddriver_xpm),tr("Install Driver"),this,"addDriverButton");
    addDriverButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(addDriverButton,tr("Install a new driver. Therefor locate the appropriate .inf file."));

    removeDriverButton = new QPushButton(QPixmap(deldriver_xpm),tr("Remove Driver"),this,"removeDriverButton");
    removeDriverButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(removeDriverButton,tr("Removes the selected driver in the list."));

    reloadButton = new QPushButton(QPixmap(reload_xpm),tr("Reload List"),this,"reloadButton");
    reloadButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(reloadButton,tr("Reload the content of the list"));

    restoreDriverButton = new QPushButton(QPixmap(restore_xpm),tr("Restore Driver"),this,"restoreDriverButton");
    restoreDriverButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(restoreDriverButton,tr("Restores a removed driver."));

    if (!disablenetconf){
      configNetworkButton = new QPushButton(QPixmap(confignetwork_xpm),tr("Config Network"),this,"configNetworkButton");
      configNetworkButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
      QToolTip::add(configNetworkButton,tr("Start's the network configuration dialog"));
    }

    quitButton = new QPushButton(QPixmap(stop_xpm),tr("Quit"),this,"quitButton");
    quitButton->setFont(QFont("Helvetic",10,QFont::Normal,false));
    QToolTip::add(quitButton,tr("Quit the application"));

    getConfProcess = new QProcess(this);
    restoreProcess = new QProcess(this);
    removeProcess = new QProcess(this);
    findNDISProcess = new QProcess(this);
    moduleCheck = new QProcess(this);
    moduleLoadedCheckProcess = new QProcess(this);
    infoProcess = new QProcess(this);
    configNetworkProcess = new QProcess(this);

    connect(getConfProcess,SIGNAL(processExited()),this,SLOT(slot_getConfProcessExited()));
    connect(quitButton,SIGNAL(clicked()),qApp,SLOT(quit()));
    connect(removeDriverButton,SIGNAL(clicked()),this,SLOT(slot_removeDriverButtonClicked()));
    connect(reloadButton,SIGNAL(clicked()),this,SLOT(slot_reloadButtonClicked()));
    connect(restoreDriverButton,SIGNAL(clicked()),this,SLOT(slot_restoreDriverButtonClicked()));
    connect(restoreProcess,SIGNAL(processExited()),this,SLOT(slot_restoreProcessExited()));
    connect(addDriverButton,SIGNAL(clicked()),this,SLOT(slot_addDriverButtonClicked()));
    connect(removeProcess,SIGNAL(processExited()),this,SLOT(slot_removeProcessExited()));
    connect(findNDISProcess,SIGNAL(processExited()),this,SLOT(slot_findNDISProcessExited()));
    connect(moduleCheck,SIGNAL(processExited()),this,SLOT(slot_moduleCheckProcessExited()));
    connect(moduleCheck,SIGNAL(readyReadStdout()),this,SLOT(slot_moduleCheckProcessReadyReadStdout()));
    connect(hardwareList,SIGNAL(contextMenuRequested(int,int,const QPoint &)),this,SLOT(slot_hardwareListRightClicked(int,int,const QPoint &)));
    connect(moduleLoadedCheckProcess,SIGNAL(processExited()),this,SLOT(slot_moduleLoadedCheckProcessExited()));
    connect(infoProcess,SIGNAL(processExited()),this,SLOT(slot_infoProcessExited()));
    connect(configNetworkProcess,SIGNAL(processExited()),this,SLOT(slot_configNetworkProcessExited()));
    if (!disablenetconf) connect(configNetworkButton,SIGNAL(clicked()),this,SLOT(slot_configNetworkRequested()));

    activateControls(addDriver|delDriver|reloadList|restoreDriver|quit|hwList|netconf);
    moveButtonTimer = new QTimer(this);
    connect(moveButtonTimer,SIGNAL(timeout()),this,SLOT(slot_buttonMoveTimerTimeout()));

    getConfFlag=false;
    initWidget();
}

kndiswrapper::~kndiswrapper()
{
}


void kndiswrapper::initWidget(){
    if (invokeSetup){
      QProcess launcher;
      launcher.addArgument("kdesu");
      launcher.addArgument("kndiswrapper");
      launcher.addArgument("--setup");
      launcher.start();
      exit(0);
    }

    if (!disablerootcheck){
      if ((QString)getenv("HOME") != "/root"){
        QString launcher;
        launcher = "kdesu ";
        launcher = launcher + "\"kndiswrapper ";
        if (qApp->argc() > 1){
          for (int i=1; i < qApp->argc();i++){
            launcher = launcher + (QString)qApp->argv()[i] + " ";
          }
        }
        launcher = launcher + "\" &";
        system(launcher);
        exit(0);
      }
    }

    findNDISProcess->addArgument("whereis");
    findNDISProcess->addArgument("ndiswrapper");
    findNDISProcess->start();
}


void kndiswrapper::resizeEvent(QResizeEvent * e){
    e = e; // Just to keep the compiler happy ..... e is not used!

    comment->setGeometry(2,2,244,this->height()-4);
    logoLabel->setGeometry(255,5,this->width()-210,40);
    hardwareList->setGeometry(255,50,this->width()-425,this->height()-55);
    hardwareList->setColumnWidth(0,hardwareList->width()-4);
    hardwareList->setShowGrid(false);
    addDriverButton->setGeometry(hardwareList->x()+hardwareList->width()+5,hardwareList->y(),this->width()-hardwareList->width()-265,40);
    removeDriverButtonEndPosition=addDriverButton->y()+addDriverButton->height()+5;
    reloadButtonEndPosition = removeDriverButtonEndPosition + addDriverButton->height()+5;
    restoreDriverButtonEndPosition = reloadButtonEndPosition + addDriverButton->height()+5;
    configNetworkButtonEndPosition = restoreDriverButtonEndPosition + addDriverButton->height()+5;
    quitButtonEndPosition = configNetworkButtonEndPosition + addDriverButton->height()+25;
    removeDriverButton->setGeometry(hardwareList->x()+hardwareList->width()+5,hardwareList->y(),this->width()-hardwareList->width()-265,40);
    reloadButton->setGeometry(hardwareList->x()+hardwareList->width()+5,hardwareList->y(),this->width()-hardwareList->width()-265,40);
    restoreDriverButton->setGeometry(hardwareList->x()+hardwareList->width()+5,hardwareList->y(),this->width()-hardwareList->width()-265,40);
    quitButton->setGeometry(hardwareList->x()+hardwareList->width()+5,hardwareList->y(),this->width()-hardwareList->width()-265,40);
    if (!disablenetconf) configNetworkButton->setGeometry(hardwareList->x()+hardwareList->width()+5,hardwareList->y(),this->width()-hardwareList->width()-265,40);
}

void kndiswrapper::getConf(){
    activateControls(disabled);
    while (hardwareList->numRows() > 0) hardwareList->removeRow(0);
    getConfProcess->clearArguments();
    getConfProcess->addArgument(ndiswrapperPath);
    getConfProcess->addArgument("-l");
    getConfProcess->start();
}

void kndiswrapper::addNewRow(QString listEntry){
    hardwareList->insertRows(hardwareList->numRows(),1);
    if (listEntry.find("invalid") > 0){
        hardwareList->setPixmap(hardwareList->numRows()-1,0,QPixmap(kndiswrapper_nok_xpm));
    } else {
        if (listEntry.find("Device present : Yes") > 0){
            hardwareList->setPixmap(hardwareList->numRows()-1,0,QPixmap(kndiswrapper_ok_xpm));
        } else {
            hardwareList->setPixmap(hardwareList->numRows()-1,0,QPixmap(kndiswrapper_xpm));
        }
    }
    hardwareList->setText(hardwareList->numRows()-1,0,listEntry);
    hardwareList->setRowHeight(hardwareList->numRows()-1,50);
}

void kndiswrapper::slot_getConfProcessExited(){
    QString rc;
    QString nextLine;
    int count = 0;
    int start,end;

    while (getConfProcess->canReadLineStdout()){
        nextLine = getConfProcess->readLineStdout();
        count++;
        switch (count){
            case 1 :  if (nextLine.find("invalid") > 0){
                addNewRow(nextLine);
                count=0;
                rc="";
            } else {
                rc = nextLine.left(nextLine.find(":")-1);
                nextLine="\n     Device present : No";
            }
            break;
            case 2 :  if (nextLine.find("present") > 0){
// Abfragen von alternate Driver
                if (nextLine.find("(alternate") > 0){
                    start=nextLine.find("(alternate");
                    end=nextLine.find(")",start);
                    end=end-start+1;
                    rc = rc + " : " + nextLine.mid(start,end);
                }
// ----------------------------------------------------
                rc = rc + "\n     Device present : Yes";
                addNewRow(rc);
                count = 0;
                rc = "";
            } else {
                addNewRow(rc + (QString)"\n     Device present : No");
                if (nextLine.find("invalid") > 0){
                    addNewRow(nextLine);
                    count=0;
                    rc="";
                } else {
                    rc = nextLine.left(nextLine.find(":")-1);
                    nextLine="\n     Device present : No";
                    count=1;
                }
            }
            break;
        }
    }
    if (rc.length() != 0) addNewRow(rc + nextLine);
    hardwareList->numRows() > 0?activateControls(addDriver|delDriver|reloadList|restoreDriver|quit|hwList|netconf):activateControls(addDriver|reloadList|restoreDriver|quit|hwList|netconf);
    getConfFlag=true;
}

void kndiswrapper::slot_removeDriverButtonClicked(){
    int rc;
    QString homePath=getenv("HOME");
    QString driver = hardwareList->text(hardwareList->currentRow(),0);
    driver = driver.left(driver.find("\n"));
    if (driver.find(":") > 0) driver = driver.left(driver.find(":")-1);
    rc = QMessageBox::question(this,tr("Remove Driver"),tr("Are you sure you want to remove the driver : ") + driver + "?",QMessageBox::Yes,QMessageBox::No);
    if (rc == QMessageBox::Yes){
        activateControls(disabled);
//       Versuche eine Sicherungskopie des Treibers zu erstellen
        rc = system("cp -r /etc/ndiswrapper/" + driver + " " + homePath + "/.kndiswrapper");
        removeProcess->clearArguments();
        removeProcess->addArgument(ndiswrapperPath);
        removeProcess->addArgument("-r");
        removeProcess->addArgument(driver);
        removeProcess->start();
    }
}

void kndiswrapper::slot_reloadButtonClicked(){
    getConf();
}

void kndiswrapper::slot_restoreProcessExited(){
    QString rc = "";

    while (restoreProcess->canReadLineStdout()){
        rc = rc + restoreProcess->readLineStdout() + "\n";
    }
    while (restoreProcess->canReadLineStderr()){
        rc = rc + restoreProcess->readLineStderr() + "\n";
    }

    if (rc.find("nstalling") > 0){
        QMessageBox::information(this,tr("Install Driver"),tr("The driver has been succesfully installed"));
    } else {
        if (rc.find("lready installed") > 0){
            QMessageBox::warning(this,tr("Warning"),tr("The driver is already installed"));
        } else {
            if (rc.find("ouldn't create") > 0){
                QMessageBox::critical(this,tr("Error"),tr("Unable to install the driver!\n\n") + rc);
            } else {
                QMessageBox::information(this,"DEBUG",tr("Unkown outcome!\n") + rc);
            }
        }
    }
    if (system(ndiswrapperPath + " -ma") != 0) QMessageBox::information(this,"DEBUG",tr("Writeing of configuration failed!"));
    if (system("modprobe -r ndiswrapper") != 0) QMessageBox::information(this,"DEBUG",tr("Removing of ndiswrapper module failed!"));
    if (system("modprobe ndiswrapper") != 0) QMessageBox::information(this,"DEBUG",tr("Loading of ndiswrapper module failed!"));
    getConf();
    activateControls(addDriver|delDriver|reloadList|restoreDriver|quit|hwList|netconf);
}

void kndiswrapper::slot_restoreDriverButtonClicked(){
    QString homePath=(QString)getenv("HOME") + "/.kndiswrapper";
    QString rc;

    rc = QFileDialog::getOpenFileName(homePath,tr("INF-Files (*.inf)"),this,tr("Removed Drivers"),tr("Select a File"));
    if (rc != ""){
        restoreProcess->clearArguments();
        restoreProcess->addArgument(ndiswrapperPath);
        restoreProcess->addArgument("-i");
        restoreProcess->addArgument(rc);
        restoreProcess->start();
    }
}

void kndiswrapper::slot_addDriverButtonClicked(){
QString homePath=(QString)getenv("HOME");
QString rc;
QString driver;
int rc2;
int rc3;
wikiLookup * hardwareInfo;
instWizard * wizard;

    rc2 = QMessageBox::question(this,"Hardware Info",tr("Do you want to use the installation wizard or do you want to select the appropirate *.inf file by yourself"),"Start Wizard","Manual Inst.","Abort Inst.");
    switch(rc2){
    case 0 : wizard = new instWizard(this,"wizard",&driver);
             rc3 = wizard->exec();
             if (rc3 == QDialog::Accepted) {
               activateControls(disabled);
               restoreProcess->clearArguments();
               restoreProcess->addArgument(ndiswrapperPath);
               restoreProcess->addArgument("-i");
               restoreProcess->addArgument(driver);
               restoreProcess->start();
             }
                break;
    case 1 : rc = QFileDialog::getOpenFileName(homePath,tr("INF-Files (*.inf)"),this,tr("New Driver"),tr("Select a File"));
             if (rc != ""){
               activateControls(disabled);
               restoreProcess->clearArguments();
               restoreProcess->addArgument(ndiswrapperPath);
               restoreProcess->addArgument("-i");
               restoreProcess->addArgument(rc);
               restoreProcess->start();
             }
                break;
    }
}

void kndiswrapper::slot_removeProcessExited(){
    QString rc = "";

    while (removeProcess->canReadLineStdout()){
        rc = rc + removeProcess->readLineStdout() + "\n";
    }
    while (removeProcess->canReadLineStderr()){
        rc = rc + removeProcess->readLineStderr() + "\n";
    }

    if (rc == ""){
        QMessageBox::information(this,tr("Removing Driver"),tr("The driver has been succesfully removed"));
    } else {
        QMessageBox::warning(this,tr("Warning"),tr("Unable to remove the driver!\n") + rc);
    }
    getConf();
    activateControls(addDriver|delDriver|reloadList|restoreDriver|quit|hwList|netconf);
}

void kndiswrapper::slot_findNDISProcessExited(){
    QString line;
    int start,end;

    while (findNDISProcess->canReadLineStdout()){
        line = line + findNDISProcess->readLineStdout();
    }

    if (line != "ndiswrapper:"){
        start=line.find("/");
        end=line.find(" ",start);
        end = end - start;
        line=line.mid(start,end);
        ndiswrapperPath = line;
        if (ndiswrapperPath == "") {
            QMessageBox::information(this,tr("Fatal Error"),tr("ndiswrapper not found.\nPlease install ndiswrapper before you proceed.\nProgram aborting!"));
            exit(1);
        }
        moduleLoadedCheckProcess->clearArguments();
        moduleLoadedCheckProcess->addArgument("lsmod");
        moduleLoadedCheckProcess->start();
    } else {
        QMessageBox::information(this,tr("Fatal Error"),tr("ndiswrapper not found.\nPlease install ndiswrapper before you proceed.\nProgram aborting!"));
        exit(1);
    }

    getConf();
    moveButtonTimer->start(8,true);
}

void kndiswrapper::slot_hardwareListRightClicked(int row, int col, const QPoint & pos){
    row = row; // Just to keep the Compiler happy .....row is not used!
    col = col; // Just to keep the Compiler happy .....col is not used!
    contextMenu->popup(pos);
}

void kndiswrapper::slot_moduleCheckRequested(){
    QString module;

    moduleCheckOutput = "";
    module = hardwareList->text(hardwareList->currentRow(),hardwareList->currentColumn());
    if (module.find("(alternate driver") > 0){
        moduleCheck->clearArguments();
        moduleCheck->addArgument("lsmod");
        moduleCheck->start();
    } else {
        module=module.left(module.find('\n'));
        if (module.find(":") > 0) module = module.left(module.find(':')-1);
        QMessageBox::information(this,tr("Attention"),tr("There is no alternativ driver for ") + module);
    }
}

void kndiswrapper::slot_moduleCheckProcessReadyReadStdout(){
    while (moduleCheck->canReadLineStdout()){
        moduleCheckOutput = moduleCheckOutput + moduleCheck->readLineStdout();
    }
}

void kndiswrapper::slot_moduleCheckProcessExited(){
    int start,end;
    QString module;
    QString message = tr("A alternativ driver is loaded by the kernel. This may\nprevent ndiswrapper from working properly. ");
    message = message + tr("We have\nto remove the loaded kernel module and blacklist the\nkernel module so it");
    message = message + tr(" will not be loaded by the kernel again.\n\nShall I try to fix the problem for you?");

    module = hardwareList->text(hardwareList->currentRow(),hardwareList->currentColumn());
    module=module.left(module.find('\n'));
    start=module.find("(alternate driver: ");
    start=start+19;
    end=module.find(")");
    end=end-start;
    module=module.mid(start,end);

    while (moduleCheck->canReadLineStdout()){
        moduleCheckOutput = moduleCheckOutput + moduleCheck->readLineStdout();
    }
    if (moduleCheckOutput.find(module) >= 0){
        message = message + tr("\nHints:\n- I will do a : rmmod ") + module + tr("\n- enter the name of the module into /etc/modprobe.d/blacklist\n- and into /etc/modprobe.conf\n\n");
        int rc=QMessageBox::question(this,"Warning",message,QMessageBox::Yes,QMessageBox::No);
        if (rc == QMessageBox::Yes){
            activateControls(disabled);
            rc = system("rmmod " + module);
            QString command="cp /etc/modprobe.d/blacklist /etc/modprobe.d/blacklist.save"; // erstellen einer Sicherungskopie
            rc = system(command);
            command = "cp /etc/modprobe.conf /etc/modprobe.conf.save"; // erstellen einer Sicherungskopie
            rc = system(command);
// Feststellen, ob ein entsprechender Eintrag bereits in der Datei "blacklist" existiert ---> wenn nein, dann erstellen.
            command = "if [ -z \"`fgrep \"blacklist " + module + "\" /etc/modprobe.d/blacklist`\" ]; then echo \"blacklist " + module + "\" >> /etc/modprobe.d/blacklist; fi";
            rc = system(command);
// Feststellen, ob ein entsprechender Eintrag bereits in der Datei modprobe.conf existiert ---> wenn nein, dann erstellen.
            command = "if [ -z \"`fgrep \"alias " + module + " off\" /etc/modprobe.conf`\" ]; then echo \"alias " + module + " off\" >> /etc/modprobe.conf; fi";
            rc = system(command);
            activateControls(addDriver|delDriver|reloadList|restoreDriver|quit|hwList|netconf);
        }
    } else {
        QMessageBox::information(this,tr("Attention"),tr("No conflicting kernel modules are loaded!\n>>>>> erverything is fine <<<<<"));
    }
}

void kndiswrapper::activateControls(int state){
    (state & addDriver) == addDriver?addDriverButton->setEnabled(true):addDriverButton->setEnabled(false);
    (state & delDriver) == delDriver?removeDriverButton->setEnabled(true):removeDriverButton->setEnabled(false);
    (state & reloadList) == reloadList?reloadButton->setEnabled(true):reloadButton->setEnabled(false);
    (state & restoreDriver) == restoreDriver?restoreDriverButton->setEnabled(true):restoreDriverButton->setEnabled(false);
    (state & quit) == quit?quitButton->setEnabled(true):quitButton->setEnabled(false);
    (state & hwList) == hwList?hardwareList->setEnabled(true):hardwareList->setEnabled(false);
    if (!disablenetconf) (state & netconf) == netconf?configNetworkButton->setEnabled(true):configNetworkButton->setEnabled(false);
}

void kndiswrapper::slot_moduleLoadedCheckProcessExited(){
    QString line;
    int rc;

    while (moduleLoadedCheckProcess->canReadLineStdout()){
        line = line + moduleLoadedCheckProcess->readLineStdout();
    }

    if (line.find("ndiswrapper") == -1){
        rc=QMessageBox::question(this,tr("WARNING"),tr("The ndiswrapper module is not loaded.\nndiswrapper will not be able to identify any hardware.\nShall I load the kernel module for you?"),QMessageBox::Yes,QMessageBox::No);
        if (rc == QMessageBox::Yes) {
            rc = system("modprobe ndiswrapper");
            if (rc != 0) QMessageBox::warning(this,tr("Warning"),tr("Loading of the kernel module (ndiswrapper) failed!"));
        }
    }
}

void kndiswrapper::slot_infoProcessRequested(){
    infoProcess->clearArguments();
    infoProcess->addArgument("dmesg");
    infoProcess->start();
}

void kndiswrapper::slot_infoProcessExited(){
    QString line="";
    QString driverInfo;
    QString module;
    int start,end;
    QString tempString;
    QString nicName;

    module = hardwareList->text(hardwareList->currentRow(),hardwareList->currentColumn());
    module=module.left(module.find('\n'));
    start=0;
    end=module.find(" ");
    end=end-start;
    module=module.mid(start,end);
    while (infoProcess->canReadLineStdout()){
        line = line + infoProcess->readLineStdout()+"\n";
    }

    tempString="ndiswrapper: driver " + module;
    start = line.findRev(tempString);
    end = line.find('\n',start);
    end = end - start;
    driverInfo = line.mid(start,end);
    line=line.mid(start+end+1);

    tempString=": " + module;
    start = line.find(tempString);
    start = line.findRev("\n",start);
    if (start == -1) start = 0;
    end = line.find("\n",start);
    end = end - start;
    nicName = line.mid(start,line.find(":",start)-start);
    if (nicName.find("\n") != -1) nicName.replace(QChar('\n'),"");
    if (nicName == "") nicName = "Not configured!";
    driverInfo = "-------------------------------------------------------------\ndmesg-Info for " + module + " (" + nicName + ")\n-------------------------------------------------------------\n\n" + driverInfo + "\n" + line.mid(start,end);
    line = line.mid(start+end+1);

    start = line.find(nicName+":");
    end = line.find("\n",start);
    end=end-start;
    driverInfo = driverInfo + "\n" + line.mid(start,end);
    line = line.mid(start+end+1);

    tempString = "ndiswrapper: device " + nicName + " removed";
    if (line.find(tempString) != -1) driverInfo = driverInfo + "\n" + tempString;

    QMessageBox::information(this,tr("dmesg-Info"),driverInfo);
}

void kndiswrapper::slot_configNetworkRequested(){
    configNetworkProcess->clearArguments();
    configNetworkProcess->addArgument("dmesg");
    configNetworkProcess->start();
}

void kndiswrapper::slot_configNetworkProcessExited(){
    QString line="";
    QString module;
    int start,end;
    QString tempString;
    QString nicName;
    bool noInterface=true;

    module = hardwareList->text(hardwareList->currentRow(),hardwareList->currentColumn());
    module=module.left(module.find('\n'));
    start=0;
    end=module.find(" ");
    end=end-start;
    module=module.mid(start,end);
    while (configNetworkProcess->canReadLineStdout()){
        line = line + configNetworkProcess->readLineStdout()+"\n";
    }

    tempString="ndiswrapper: driver " + module;
    start = line.findRev(tempString);
    end = line.find('\n',start);
    end = end - start;
    line=line.mid(start+end+1);

    tempString=": " + module;
    start = line.find(tempString);
    start = line.findRev("\n",start);
    if (start == -1) start = 0;
    end = line.find("\n",start);
    end = end - start;
    nicName = line.mid(start,line.find(":",start)-start);
    if (nicName.find('\n') != -1) nicName.replace(QChar('\n'),"");

    line = line.mid(start+end+1);
    start = line.find(nicName+":");
    end = line.find("\n",start);
    end=end-start;

    line = line.mid(start+end+1);
    tempString = "ndiswrapper: device " + nicName + " removed";
    if (line.find(tempString) == -1) noInterface = false;
    if ((nicName != "") && (noInterface == false)){
        wifiSetup * dialog = new wifiSetup(this,"dialog",nicName);
        dialog->show();
    } else {
        QMessageBox::warning(this,tr("Warning"),tr("Can't start the network configuration! No interface found!"));
    }
}

void kndiswrapper::slot_buttonMoveTimerTimeout(){
int y;
int x;

    if (getConfFlag){
      x = removeDriverButton->x();

      y = removeDriverButton->y();
      if (removeDriverButtonEndPosition > y){
        y++;
        removeDriverButton->move(x,y);
      }

      y = reloadButton->y();
      if (reloadButtonEndPosition > y){
        y+=2;
        reloadButton->move(x,y);
      }

      y = restoreDriverButton->y();
      if (restoreDriverButtonEndPosition > y){
        y+=3;
        restoreDriverButton->move(x,y);
      }

      if (!disablenetconf){
        y = configNetworkButton->y();
        if (configNetworkButtonEndPosition > y){
          y+=4;
          configNetworkButton->move(x,y);
        }
      }

      y = quitButton->y();
      if (quitButtonEndPosition > y) {
        y+=5;
        quitButton->move(x,y);
        moveButtonTimer->start(6,true);
      }
  } else {
    moveButtonTimer->start(6,true);
  }
}

void kndiswrapper::slot_wikiRequested(){
wikiLookup * hardwareInfo;

    hardwareInfo = new wikiLookup(this,"hardwareInfo",1);
    hardwareInfo->exec();
}

#include "kndiswrapper.moc"
