/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef INSTWIZARD_H
#define INSTWIZARD_H

#include <qmultilineedit.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <wikilookup.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qprocess.h>
#include <qtooltip.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qframe.h>
#include <qtable.h>
#include <qfont.h>
#include <stdio.h>
#include <stdlib.h>


/**
	@author Joerg Zopes <joerg.zopes@linux-specialist.com>
*/
class instWizard : public QDialog
{
Q_OBJECT
public:
    instWizard(QWidget *parent = 0, const char *name = 0, QString * driver = 0);
    ~instWizard();

private:
    QLabel          * deviceLabel;
    QLabel          * headerLabel;
    QLabel          * possibleHitsLabel;
    QLabel          * driverLabel;
    QComboBox       * deviceComboBox;
    QFrame          * mainFrame;
    QFrame          * driverFrame;
    QTable          * resultTable;
    QProcess        * lsusbProcess;
    QProcess        * searchProcess;
    QProcess        * searchProcess2;
    QMultiLineEdit  * comment;
    QPushButton     * fileSelectButton;
    QPushButton     * wikiLookupButton;
    QPushButton     * startSearchButton;
    QPushButton     * startInstButton;
    QPushButton     * cancelInstButton;
    QLineEdit       * searchPath;
    QLineEdit       * driverEdit;
    QLabel          * searchLabel;
    QString         * driverRC;
    QString            infFileGlobal;
    void resizeEvent(QResizeEvent *);
    void tryAgain(QString, QString,QString);

private slots:
    void slot_lsusbProcessExited();
    void slot_fileSelectButtonClicked();
    void slot_wikiLookupButtonClicked();
    void slot_startSearchButtonClicked();
    void slot_searchProcessExited();
    void slot_searchProcess2Exited();
    void slot_resultTableClicked();
    void slot_cancelInstButtonClicked();
    void slot_startInstButtonClicked();
};

#endif
