/*
 * 動的バッファーライブラリ
 */

#ifndef MINATO__BUFFER_H
#define MINATO__BUFFER_H

#define BOOL int
#define TRUE 1
#define FALSE 0

/* 動的バッファーオブジェクト */
typedef struct {
    void* mBuffer;
    int mBufferSize;            // バイト
    
    void* mPointer;
} buffer_obj;

//////////////////////////////////////////////////////////////////////
// 関数定義
//////////////////////////////////////////////////////////////////////
// 初期化
#ifdef MDEBUG

buffer_obj* buffer_new_debug(int first_size, const char* fname, int line, const char* func_name);
#define BUFFER_NEW(size) buffer_new_debug(size, __FILE__, __LINE__, __FUNCTION__)

#else

buffer_obj* buffer_new(int first_size);
#define BUFFER_NEW(size) buffer_new(size)

#endif

void buffer_delete(buffer_obj* self);                           // 解放
void buffer_add_int(buffer_obj* self, int n);
void buffer_add_char(buffer_obj* self, char c);
void buffer_add_pchar(buffer_obj* self, char* str);


#endif

