/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "loginprefpage.h"

#include "libkita/kitaconfig.h"

#include <qcheckbox.h>

#include <kpassdlg.h>
#include <klineedit.h>

using namespace Kita;
LoginPrefPage::LoginPrefPage( QWidget *parent )
        : LoginPrefBase( parent )
{
    userIDLine->setText( KitaConfig::userID() );
    passwordLine->insert( KitaConfig::password() );
    autoLoginCheckBox->setChecked( KitaConfig::autoLogin() );
    BeMailAddressLine->setText( KitaConfig::BeMailAddress() );
    BeAuthCodeLine->insert( KitaConfig::BeAuthCode() );

    connect( userIDLine, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    connect( passwordLine, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    connect( autoLoginCheckBox, SIGNAL( toggled( bool ) ), SIGNAL( changed() ) );
    connect( BeMailAddressLine, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    connect( BeAuthCodeLine, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
}


LoginPrefPage::~LoginPrefPage()
{}

void LoginPrefPage::apply()
{
    KitaConfig::setUserID( userIDLine->text() );
    KitaConfig::setPassword( passwordLine->password() );
    KitaConfig::setAutoLogin( autoLoginCheckBox->isChecked() );
    KitaConfig::setBeMailAddress( BeMailAddressLine->text() );
    KitaConfig::setBeAuthCode( BeAuthCodeLine->text() );
}

#include "loginprefpage.moc"
