/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "htmlview.h"

#include <khtml_part.h>

#include <qapplication.h>
#include <qclipboard.h>

KitaHTMLView::KitaHTMLView( KHTMLPart* part, QWidget *parent, const char *name )
        : KHTMLView( part, parent, name )
{}

KitaHTMLView::~KitaHTMLView()
{}

void KitaHTMLView::leaveEvent( QEvent* )
{
    emit leave();
}

/* protected */
void KitaHTMLView::keyPressEvent( QKeyEvent* e )
{
    if ( e->key() == Key_Space || e->key() == Key_PageDown
            || e->key() == Key_Down || e->key() == Key_End ) {
        if ( emitPushDown() ) return ;
    }

    KHTMLView::keyPressEvent( e );
}

/* protected */
void KitaHTMLView::viewportWheelEvent( QWheelEvent * e )
{
    if ( e->delta() < 0 ) { /* scroll down */
        if ( emitPushDown() ) return ;
    }

    KHTMLView::viewportWheelEvent( e );
}

/* private */
bool KitaHTMLView::emitPushDown()
{

    int y = contentsY();
    if ( y >= contentsHeight() - visibleHeight() ) {
        emit pushDown(); /* to KitaHTMLPart in order to call slotClickTugi100 */
        return TRUE;
    }

    return FALSE;
}
