/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITABBSTABWIDGET_H
#define KITABBSTABWIDGET_H

#include "kitaui/tabwidgetbase.h"

class QFont;

/*------------------------------------------------*/


class KitaBBSTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT

public:
    KitaBBSTabWidget( QWidget* parent, const char* name = 0, WFlags fl = 0 );
    ~KitaBBSTabWidget();

public slots:
    void showBoardList();
    void updateBoardList();
    void setFont( const QFont& font );
    void loadOpened();

protected:
    virtual void deleteWidget( QWidget* w );
};


/*--------------------------------------------------*/


class KitaBBSDock : public KitaDockWidgetBase
{

    Q_OBJECT
    KitaBBSTabWidget* m_boardTab;
public:
    KitaBBSDock( KDockManager* dockManager,
                   const char* name,
                   const QPixmap &pixmap,
                   QWidget* parent = 0L,
                   const QString& strCaption = QString::null,
                   const QString& strTabPageLabel = QString::fromLatin1( " " ),
                   WFlags f = 0 );
    ~KitaBBSDock();

    KitaBBSTabWidget* setup();
};



#endif
