/*
 * Copyright (C) 2003 Zsolt Rizsanyi <rizsanyi@myrealbox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#ifndef __TELEXIFACE_H__
#define __TELEXIFACE_H__

#include <dcopobject.h>

/**
 * A DCOP interface for the teletext plugin
 *
 * @author Zsolt Rizsanyi, rizsanyi@myrealbox.com
 */
class TelexIface : virtual public DCOPObject
{
    K_DCOP
k_dcop:

    virtual void showDisplay(bool show) = 0;
    virtual void toggleShow() = 0;
    virtual void toggleTransparent() = 0;
    virtual void toggleReveal() = 0;

    virtual void navigate(int page) = 0;
    virtual void nextPage() = 0;
    virtual void previousPage() = 0;
};

#endif // __TELEXIFACE_H__


// vim: ts=4 et
