// -*- c++ -*-
/***************************************************************************
                           channelimporter.h
                           -----------------
    begin                : Sat Oct 25 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CHANNELIMPORTER_H
#define CHANNELIMPORTER_H

#include <qobject.h>
#include <qstring.h>

class ChannelStore;
class QStringList;
class KConfig;

/**
 * Imports default channel lists
 * @author Dirk Ziegelmeier <dziegel@gmx.de>
 */
class ChannelImporter : public QObject
{
    Q_OBJECT
	
public: 
    ChannelImporter();
    virtual ~ChannelImporter();

    /// Returns available channel lists
    QStringList lists();

    /// imports desired list to store
    bool import(ChannelStore*, const QString& list);


private:
    KConfig* _map;
    QString  _path;
};

#endif
