// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */


#ifndef KDETVVIEWIFACE_H
#define KDETVVIEWIFACE_H

#include <dcopobject.h>
#include <dcopref.h>

/**
 * A DCOP interface for KdetvWidget.
 *
 * @author Richard Moore, rich@kde.org
 */
class KdetvViewIface : virtual public DCOPObject
{
    K_DCOP
k_dcop:
    /**
     * Switches to the next view mode.
     */
    virtual void nextViewMode()=0;

    /**
     * Activates the specified view mode.
     */
    virtual void setViewMode( int mode )=0;

    virtual void setViewModeNone()=0;
    virtual void setViewModeNormal()=0;
    virtual void setViewModeTV()=0;
    virtual void setViewModeFullScreen()=0;
    virtual void setViewModeVideoDesktop()=0;

    virtual void toggleFullScreen()=0;
};

#endif

// Local Variables:
// c-basic-offset: 4
// End:

