//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Text;
    /// <remarks>
    ///  \class KLockFile klockfile.h <KLockFile>
    ///  The KLockFile class provides NFS safe lockfiles.
    /// </remarks>        <author> Waldo Bastian <bastian@kde.org>
    ///  </author>
    ///         <short>    \class KLockFile klockfile.</short>
    [SmokeClass("KLockFile")]
    public class KLockFile : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KLockFile(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KLockFile), this);
        }
        /// <remarks>
        ///  Possible return values of the lock function.
        ///     </remarks>        <short>    Possible return values of the lock function.</short>
        public enum LockResult {
            LockOK = 0,
            LockFail = 1,
            LockError = 2,
            LockStale = 3,
        }
        public enum LockFlag {
            NoBlockFlag = 1,
            ForceFlag = 2,
        }
        public KLockFile(string file, KComponentData componentName) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLockFile$#", "KLockFile(const QString&, const KComponentData&)", typeof(void), typeof(string), file, typeof(KComponentData), componentName);
        }
        public KLockFile(string file) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLockFile$", "KLockFile(const QString&)", typeof(void), typeof(string), file);
        }
        /// <remarks>
        ///  Attempt to acquire the lock
        /// <param> name="flags" A set of <see cref="LockFlag"></see> values OR'ed together.
        ///     </param></remarks>        <short>    Attempt to acquire the lock </short>
        public KLockFile.LockResult Lock(uint flags) {
            return (KLockFile.LockResult) interceptor.Invoke("lock$", "lock(KLockFile::LockFlags)", typeof(KLockFile.LockResult), typeof(uint), flags);
        }
        public KLockFile.LockResult Lock() {
            return (KLockFile.LockResult) interceptor.Invoke("lock", "lock()", typeof(KLockFile.LockResult));
        }
        /// <remarks>
        ///  Returns whether the lock is held or not
        ///     </remarks>        <short>    Returns whether the lock is held or not     </short>
        public bool IsLocked() {
            return (bool) interceptor.Invoke("isLocked", "isLocked() const", typeof(bool));
        }
        /// <remarks>
        ///  Release the lock
        ///     </remarks>        <short>    Release the lock     </short>
        public void Unlock() {
            interceptor.Invoke("unlock", "unlock()", typeof(void));
        }
        /// <remarks>
        ///  Return the time in seconds after which a lock is considered stale
        ///  The default is 30.
        ///     </remarks>        <short>    Return the time in seconds after which a lock is considered stale  The default is 30.</short>
        public int StaleTime() {
            return (int) interceptor.Invoke("staleTime", "staleTime() const", typeof(int));
        }
        /// <remarks>
        ///  Set the time in seconds after which a lock is considered stale
        ///     </remarks>        <short>    Set the time in seconds after which a lock is considered stale     </short>
        public void SetStaleTime(int _staleTime) {
            interceptor.Invoke("setStaleTime$", "setStaleTime(int)", typeof(void), typeof(int), _staleTime);
        }
        /// <remarks>
        ///  Returns the pid, hostname and appname of the process holding
        ///  the lock after the lock functon has returned with LockStale.
        /// </remarks>        <return> false if the pid and hostname could not be determined
        ///     </return>
        ///         <short>    Returns the pid, hostname and appname of the process holding  the lock after the lock functon has returned with LockStale.</short>
        public bool GetLockInfo(ref int pid, StringBuilder hostname, StringBuilder appname) {
            StackItem[] stack = new StackItem[4];
            stack[1].s_int = pid;
#if DEBUG
            stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(hostname);
#else
            stack[2].s_class = (IntPtr) GCHandle.Alloc(hostname);
#endif
#if DEBUG
            stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(appname);
#else
            stack[3].s_class = (IntPtr) GCHandle.Alloc(appname);
#endif
            interceptor.Invoke("getLockInfo$$$", "getLockInfo(int&, QString&, QString&)", stack);
            pid = stack[1].s_int;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
            ((GCHandle) stack[2].s_class).SynchronizedFree();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
            ((GCHandle) stack[3].s_class).SynchronizedFree();
#endif
            return stack[0].s_bool;
        }
        ~KLockFile() {
            interceptor.Invoke("~KLockFile", "~KLockFile()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KLockFile", "~KLockFile()", typeof(void));
        }
    }
}
