#ifndef K3DSDK_NGUI_TUTORIALS_H
#define K3DSDK_NGUI_TUTORIALS_H

// K-3D
// Copyright (c) 1995-2008, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
	\author Tim Shead (tshead@k-3d.com)
*/

namespace k3d
{

namespace ngui
{

namespace tutorial
{

/// Call this to indicate that tutorial recording has been started.
void recording_started();
/// Returns true if a tutorial is currently being recorded
const bool recording();
/// Call this to indicate that tutorial recording has finished.
void recording_finished();

/// Call this to indicate that tutorial playback has been started.
void playback_started();
/// Returns true if a tutorial is currently playing
const bool playing();
/// Call this to indicate that tutorial playback has finished.
void playback_finished();

} // namespace tutorial

} // namespace ngui

} // namespace k3d

#endif // !K3DSDK_NGUI_TUTORIALS_H

