/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wordsprediction.h"

#include <asciiplugin.h>

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

WordsPrediction::WordsPrediction(ConfigPointer cfg) : Predictor(cfg)
{
    String file = cfg->read(HONOKA_CONFIG_WORDSPREDICTION_FILE,String(HONOKA_DEFAULT_WORDSPREDICTION_FILE));
    dic = new WordsDic(file);
    pos = 0;
    addSpace = cfg->read(HONOKA_CONFIG_WORDSPREDICTION_ADDSAW,HONOKA_DEFAULT_WORDSPREDICTION_ADDSAW);
    limit = cfg->read(HONOKA_CONFIG_WORDSPREDICTION_LIMIT,HONOKA_DEFAULT_WORDSPREDICTION_LIMIT);
}


WordsPrediction::~WordsPrediction()
{
    delete dic;
}

/*!
    \fn WordsPrediction::getPredictionList(const WideString &str)
 */
ResultList WordsPrediction::getPredictionList(const WideString &str)
{
    ResultList l;
    WideString word,prewords;
    for(unsigned int i = str.length();i > 0;i --) {
        //if (isalnum(utf8_wcstombs(str).c_str()[i - 1]))
        if (((str[i - 1] >= 0x0041) && (str[i - 1] <= 0x005A)) ||   // ʸ
            ((str[i - 1] >= 0x0061) && (str[i - 1] <= 0x007A)) ||   // ʸ
            ((str[i - 1] >= 0x0030) && (str[i - 1] <= 0x0039)) ||   // 
            (str[i - 1] == 0x002D))                                 // ϥե
            word = str[i - 1] + word;
        else break;
    }
    if (!word.length()) return l;
    prewords = str.substr(0,str.length() - word.length());
    pos = prewords.length();
    set<string> res = dic->find(utf8_wcstombs(word).c_str());
    if (res.size() > limit) {
        l.Title = utf8_mbstowcs(String(_("too many prediction results!")));
        l.kType = PREDICTION;
        l.kouho.push_back(ResultEntry(str,word));
    } else if (res.size() == 0) {
        l.Title = utf8_mbstowcs(String(_("no prediction results!")));
        l.kType = PREDICTION;
        l.kouho.push_back(ResultEntry(str,word));
    } else {
        l.Title = utf8_mbstowcs(String(_("lookup result")));
        l.kType = PREDICTION;
        for(set<string>::iterator it = res.begin();it != res.end();it ++) {
            if (addSpace) l.kouho.push_back(ResultEntry(prewords + utf8_mbstowcs(*it) + utf8_mbstowcs(" "),utf8_mbstowcs(*it)));
            else l.kouho.push_back(ResultEntry(prewords + utf8_mbstowcs(*it),utf8_mbstowcs(*it)));
        }
    }
    return l;
}


/*!
    \fn WordsPrediction::disconnect()
 */
void WordsPrediction::disconnect()
{
    return;
}


/*!
    \fn WordsPrediction::connect()
 */
bool WordsPrediction::connect()
{
    return true;
}


/*!
    \fn WordsPrediction::isConnected()
 */
bool WordsPrediction::isConnected()
{
    return true;
}


/*!
    \fn WordsPrediction::getPropertyName()
 */
String WordsPrediction::getPropertyName()
{
    return String(_("WordsPrediction"));
}

/*!
    \fn WordsPrediction::getName()
 */
String WordsPrediction::getName()
{
    return String("WordsPrediction");
}

/*!
    \fn WordsPrediction::update(const WideString str,const WideString yomi)
 */
void WordsPrediction::update(const WideString str,const WideString yomi)
{
    return;
}




/*!
    \fn Honoka::WordsPrediction::getPos()
 */
int Honoka::WordsPrediction::getPos()
{
    return pos;
}
