/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HONOKASETUPGTK_H
#define HONOKASETUPGTK_H

#define Uses_SCIM_CONFIG_BASE

#include <scim.h>
#include <gtk/scimkeyselection.h>
#include <gtk/gtk.h>
#include <vector>
#include <cstdio>
#include <cstdlib>
#include <honokasetupcore.h>


using namespace scim;
using namespace std;


/**
@author TAM (Teppei Tamra)
*/

// for GTK

#define     HonokaSetupItem         HonokaSetupGtkItem
#define     HonokaSetupEntryItem    HonokaSetupGtkEntryItem
#define     HonokaSetupFileItem     HonokaSetupGtkFileItem
#define     HonokaSetupKeyItem      HonokaSetupGtkKeyItem
#define     HonokaSetupBoolItem     HonokaSetupGtkBoolItem
#define     HonokaSetupIntItem      HonokaSetupGtkIntItem
#define     HonokaSetupSelectItem   HonokaSetupGtkSelectItem
#define     HonokaSetupPage         HonokaSetupGtkPage
#define     HonokaSetup             HonokaSetupGtk


class HonokaSetupGtkItem {
public:
    GtkWidget *getValueWidget();
    GtkWidget *getLabelWidget();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
    static bool changed;
protected:
    virtual void createLabelWidget();
    virtual void createValueWidget();
    virtual void createTipWidget();
    HonokaSetupGtkItem(String _label,String _name,String _tip);
    ~HonokaSetupGtkItem();
    void createWidgets();
    String label;
    String name;
    String tip;
    GtkWidget *valueWidget;
    GtkWidget *labelWidget;
    static GtkTooltips *tipWidget;
};

class HonokaSetupGtkContainer {
public:
    HonokaSetupGtkItem * getLastItem();
protected:
    HonokaSetupGtkContainer();
    ~HonokaSetupGtkContainer();
    virtual void append(HonokaSetupGtkItem *item);
    vector<HonokaSetupGtkItem *> items;
};

class HonokaSetupGtkEntryItem : public HonokaSetupGtkItem {
public:
    HonokaSetupGtkEntryItem(String _label,String _name,String _tip,String _default);
    ~HonokaSetupGtkEntryItem();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    static void onEditableChanged(GtkEditable *widget,gpointer self);
    String stringData;
};

class HonokaSetupGtkKeyItem : public HonokaSetupGtkItem {
public:
    HonokaSetupGtkKeyItem(String _label,String _name,String _tip,String _default);
    ~HonokaSetupGtkKeyItem();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    virtual void createTipWidget();
    static void onEditableChanged(GtkEditable *widget,gpointer self);
    static void onSelectButtonClicked(GtkEditable *widget,gpointer self);
    String stringData;
    GtkWidget *entry;
    GtkWidget *button;
};

class HonokaSetupGtkFileItem : public HonokaSetupGtkItem {
public:
    HonokaSetupGtkFileItem(String _label,String _name,String _tip,String _default);
    ~HonokaSetupGtkFileItem();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    virtual void createTipWidget();
    static void onEditableChanged(GtkEditable *widget,gpointer self);
    static void onSelectButtonClicked(GtkEditable *widget,gpointer self);
    static void onOkButtonClicked(GtkButton *widget,gpointer ok);
    String stringData;
    GtkWidget *entry;
    GtkWidget *button;
};

class HonokaSetupGtkBoolItem : public HonokaSetupGtkItem {
public:
    HonokaSetupGtkBoolItem(String _label,String _name,String _tip,bool _default);
    ~HonokaSetupGtkBoolItem();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    static void onToggleButtonToggled(GtkEditable *widget,gpointer self);
    bool boolData;
};

class HonokaSetupGtkIntItem : public HonokaSetupGtkItem {
public:
    HonokaSetupGtkIntItem(String _label,String _name,String _tip,int _default,int lower,int upper);
    ~HonokaSetupGtkIntItem();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    static void onValueChanged(GtkSpinButton *widget,gpointer self);
    int intData;
    GtkAdjustment* aj;
};

class HonokaSetupGtkSelectItem : public HonokaSetupGtkItem {
public:
    HonokaSetupGtkSelectItem(String _label,String _name,String _tip,String _default,vector<String> _list);
    ~HonokaSetupGtkSelectItem();
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    static void onSelected(GtkOptionMenu *widget,gpointer self);
    GtkWidget *menu;
    vector<String> stringListData;
    String stringData;
};


class HonokaSetupGtkPage: public HonokaSetupGtkItem ,public HonokaSetupGtkContainer {
public:
    HonokaSetupGtkPage(String _label,String _name,String _tip);
    ~HonokaSetupGtkPage();
    virtual void append(HonokaSetupGtkItem *item);
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
protected:
    GtkWidget *table;
};


class HonokaSetupGtk: public HonokaSetupGtkItem ,public HonokaSetupGtkContainer {
public:
    HonokaSetupGtk(String _label,String _name,String _tip);
    ~HonokaSetupGtk();
    static HonokaSetupGtkItem *HonokaSetupCoreToGtk(Honoka::HonokaSetupCoreItem *item);
    virtual void append(HonokaSetupGtkItem *page);
    virtual void readConfig(ConfigPointer cfg);
    virtual void saveConfig(ConfigPointer cfg);
};

#endif
