/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.testng.junit.JUnitDirectoryConverter;

public class JUnitConverterTask
extends Task {
    private File m_sourceDirectory;
    private File m_outputDirectory;
    private boolean m_useAnnotations;

    public void execute() throws BuildException {
        this.validate();
        JUnitDirectoryConverter convertor = new JUnitDirectoryConverter(this.m_sourceDirectory, this.m_outputDirectory, null, this.m_useAnnotations);
        int result = convertor.convert();
        if (result > -1) {
            this.log(result + " files generated");
        } else {
            this.log("There were errors in file generation");
        }
    }

    private void validate() throws BuildException {
        if (this.m_outputDirectory == null || this.m_outputDirectory.equals("")) {
            throw new BuildException("OutputDir must have a value");
        }
        if (this.m_sourceDirectory == null || this.m_sourceDirectory.equals("")) {
            throw new BuildException("SourceDir must have a value");
        }
    }

    public void init() throws BuildException {
        super.init();
        this.m_useAnnotations = true;
    }

    public void setOutputDir(File outputDirectory) {
        this.m_outputDirectory = outputDirectory;
    }

    public void setSourceDir(File sourceDirectory) {
        this.m_sourceDirectory = sourceDirectory;
    }

    public void setAnnotations(boolean annotations) {
        this.m_useAnnotations = annotations;
    }
}

