
#==============================================================================#
# $Id: property.rb,v 1.4 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/property.rb,v $
#==============================================================================#

require 'grb/chart/base/property'
require 'grb/chart/base/property/composite/scale'
require 'grb/chart/base/property/composite/axis'
require 'grb/chart/xy_base/utility/scale'
require 'grb/chart/xy_base/decorator/base_line'
require 'grb/chart/xy_base/decorator/orign_line'
require 'grb/chart/xy_base/decorator/scale_grid'
require 'grb/chart/xy_base/decorator/scale_tics'
require 'grb/chart/xy_base/decorator/scale_label'
require 'grb/chart/xy_base/decorator/axis_major_grid'
require 'grb/chart/xy_base/decorator/axis_minor_grid'
require 'grb/chart/xy_base/decorator/axis_major_tics'
require 'grb/chart/xy_base/decorator/axis_minor_tics'
require 'grb/chart/xy_base/decorator/axis_label'

#==============================================================================#

module GRb

  module Chart

    class XYChartPropertyBase < ChartPropertyBase

      def initialize
        super()
        @scale1 = ScaleProperty.new
        @scale2 = ScaleProperty.new
        @axis   = AxisProperty.new
      end

      attr_accessor :scale1, :scale2, :axis

      def setup
        super()

        @scale1.maximum             = 50
        @scale1.minimum             = 0
        @scale1.interval.major      = 10
        @scale1.interval.minor      = 2
        @scale1.grid.major.visible  = true
        @scale1.grid.major.color    = GRb::Color.gray(192)
        @scale1.grid.minor.visible  = true
        @scale1.grid.minor.color    = GRb::Color.gray(240)
        @scale1.tics.major.visible  = true
        @scale1.tics.major.color    = GRb::Color.black
        @scale1.tics.major.size     = 5
        @scale1.tics.major.inside   = true
        @scale1.tics.major.outside  = false
        @scale1.tics.minor.visible  = true
        @scale1.tics.minor.color    = GRb::Color.black
        @scale1.tics.minor.size     = 3
        @scale1.tics.minor.inside   = true
        @scale1.tics.minor.outside  = false
        @scale1.origin.visible      = true
        @scale1.origin.color        = GRb::Color.black
        @scale1.label.visible       = true
        @scale1.label.format        = Proc.new { |value| value.to_s }
        @scale1.label.font.color    = GRb::Color.blue
        @scale1.label.font.name     = GRb::Chart::Font::Small
        @scale1.label.font.vertical = false
        @scale1.label.font.filepath = nil
        @scale1.label.font.size     = 10
        @scale1.label.font.angle    = 0

=begin
        @scale2.maximum            = 50
        @scale2.minimum            = 0
        @scale2.interval.major     = 10
        @scale2.interval.minor     = 5
        @scale2.grid.major.visible = true
        @scale2.grid.major.color   = GRb::Color.gray(255)
        @scale2.grid.minor.visible = true
        @scale2.grid.minor.color   = GRb::Color.gray(192)
        @scale2.tics.major.visible = true
        @scale2.tics.major.color   = GRb::Color.black
        @scale2.tics.major.size    = 5
        @scale2.tics.major.inside  = true
        @scale2.tics.major.outside = true
        @scale2.tics.minor.visible = true
        @scale2.tics.minor.color   = GRb::Color.black
        @scale2.tics.minor.size    = 3
        @scale2.tics.minor.inside  = true
        @scale2.tics.minor.outside = false
        @scale2.origin.visible     = true
        @scale2.origin.color       = GRb::Color.red
        @scale2.font.color         = GRb::Color.blue
        @scale2.font.name          = GRb::Chart::Font::Small
        @scale2.font.vertical      = false
        @scale2.font.filepath      = nil
        @scale2.font.size          = 10
        @scale2.font.angle         = 0
=end

        @axis.grid.major.visible  = true
        @axis.grid.major.color    = GRb::Color.gray(192)
        @axis.grid.minor.visible  = true
        @axis.grid.minor.color    = GRb::Color.gray(240)
        @axis.tics.major.visible  = true
        @axis.tics.major.color    = GRb::Color.black
        @axis.tics.major.size     = 5
        @axis.tics.major.inside   = true
        @axis.tics.major.outside  = false
        @axis.tics.minor.visible  = true
        @axis.tics.minor.color    = GRb::Color.black
        @axis.tics.minor.size     = 3
        @axis.tics.minor.inside   = true
        @axis.tics.minor.outside  = false
        @axis.label.visible       = true
        @axis.label.text          = []
        @axis.label.font.name     = GRb::Chart::Font::Small
        @axis.label.font.vertical = false
        @axis.label.font.color    = GRb::Color.red
      end

      def create_major_scale
        scale = GRb::Chart::Scale.new
        scale.maximum  = @scale1.maximum
        scale.minimum  = @scale1.minimum
        scale.interval = @scale1.interval.major

        return scale
      end

      def create_minor_scale
        scale = GRb::Chart::Scale.new
        scale.maximum  = @scale1.maximum
        scale.minimum  = @scale1.minimum
        scale.interval = @scale1.interval.minor

        return scale
      end

      def create_baseline
        part = BaseLineDecorator.new
        part.color = GRb::Color.black

        return part
      end

      def create_scale1_origin(major_scale)
        return nil unless @scale1.origin.visible

        part = OriginLineDecorator.new
        part.scale = major_scale
        part.color = @scale1.origin.color

        return part
      end

      def create_scale1_grid_major(major_scale)
        return nil unless @scale1.grid.major.visible

        part = ScaleGridDecorator.new
        part.scale = major_scale
        part.color = @scale1.grid.major.color

        return part
      end

      def create_scale1_grid_minor(minor_scale)
        return nil unless @scale1.grid.minor.visible

        part = ScaleGridDecorator.new
        part.scale = minor_scale
        part.color = @scale1.grid.minor.color

        return part
      end

      def create_scale1_tics_major(major_scale)
        return nil unless @scale1.tics.major.visible

        part = ScaleTicsDecorator.new
        part.scale   = major_scale
        part.size    = @scale1.tics.major.size
        part.color   = @scale1.tics.major.color
        part.inside  = @scale1.tics.major.inside
        part.outside = @scale1.tics.major.outside

        return part
      end

      def create_scale1_tics_minor(minor_scale)
        return nil unless @scale1.tics.minor.visible

        part = ScaleTicsDecorator.new
        part.scale   = minor_scale
        part.size    = @scale1.tics.minor.size
        part.color   = @scale1.tics.minor.color
        part.inside  = @scale1.tics.minor.inside
        part.outside = @scale1.tics.minor.outside

        return part
      end

      def create_scale_label(major_scale)
        return nil unless @scale1.label.visible

        scale_label = ScaleLabelDecorator.new
        scale_label.scale  = major_scale
        scale_label.font   = @scale1.label.font.create_font
        scale_label.format = @scale1.label.format

        return scale_label
      end

      def create_axis_grid_major(items)
        return nil unless @axis.grid.major.visible

        part = AxisMajorGridDecorator.new
        part.color  = @axis.grid.major.color
        part.number = items

        return part
      end

      def create_axis_grid_minor(items)
        return nil unless @axis.grid.minor.visible

        part = AxisMinorGridDecorator.new
        part.number = items
        part.color  = @axis.grid.minor.color

        return part
      end

      def create_axis_tics_major(items)
        return nil unless @axis.tics.major.visible

        part = AxisMajorTicsDecorator.new
        part.number  = items
        part.color   = @axis.tics.major.color
        part.size    = @axis.tics.major.size
        part.inside  = @axis.tics.major.inside
        part.outside = @axis.tics.major.outside

        return part
      end

      def create_axis_tics_minor(items)
        return nil unless @axis.tics.minor.visible

        part = AxisMinorTicsDecorator.new
        part.number  = items
        part.color   = @axis.tics.minor.color
        part.size    = @axis.tics.minor.size
        part.inside  = @axis.tics.minor.inside
        part.outside = @axis.tics.minor.outside

        return part
      end

      def create_axis_label(items)
        return nil unless @axis.label.visible

        axis_label = AxisLabelDecorator.new
        axis_label.number = items
        axis_label.label  = @axis.label.text
        axis_label.font   = @axis.label.font.create_font

        return axis_label
      end

    end # XYChartPropertyBase

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
