
#==============================================================================#
# $Id: border.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/border.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/decorator/border'

#==============================================================================#

module GRb

  module Chart

    class BorderProperty < PropertyBase

      def initialize
        @visible = nil
        @color   = nil
        @width   = nil
      end

      attr_accessor :visible, :color, :width

      def create_decorator(child)
        if @visible
          decorator = BorderDecorator.new(child)
          decorator.color = @color || Color.black
          decorator.width = @width || 1
          return decorator
        else
          return child
        end
      end

    end # BorderProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
