
#==============================================================================#
# $Id: plural_base.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/plural_base.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/base'

#==============================================================================#

module GRb

  module Chart

    class PluralDecoratorBase < DecoratorBase

      include Enumerable

      def initialize(*children)
        super()
        @children = children
      end

      def has_child?
        return !@children.empty?
      end
      protected :has_child?

      def each(&block)
        @children.each(&block)
      end

      def size
        return @children.size
      end

      def empty?
        return @children.empty?
      end

      def draw(image, box)
        draw_self(image, box)
        draw_child(image, box) if self.has_child?
      end

      def draw_self(image, box)
        # nop
      end
      protected :draw_self

      def draw_child(image, box)
        # nop
      end
      protected :draw_child

    end # PluralDecoratorBase

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
