#! /usr/bin/ruby

#==============================================================================#
# $Id: poly.rb,v 1.3 2004/01/13 05:35:22 yuya Exp $
#==============================================================================#

require 'grb/grb'

#==============================================================================#

img = GRb::Image.create(300, 200)

grid  = GRb::Color.new(208, 208, 208)
red   = GRb::Color.red(128)
green = GRb::Color.green(128)
blue  = GRb::Color.blue(128)

0.step(300, 10) { |x| img.line(x, 0, x, 199, grid) }
0.step(200, 10) { |y| img.line(0, y, 299, y, grid) }

poly = GRb::Polygon.new
poly.add(0, -15)
poly.add(20, 15)
poly.add(-20, 15)

img.polygon(poly.move( 30, 25), :color => red, :width => 1)
img.polygon(poly.move( 90, 25), :color => red, :width => 2)
img.polygon(poly.move(150, 25), :color => red, :width => 3)
img.polygon(poly.move(210, 25), :color => red, :width => 4)
img.polygon(poly.move(270, 25), :color => red, :width => 5)

img.polygon(poly.move( 30, 75), :color => red, :width => 5, :opacity => 100)
img.polygon(poly.move( 90, 75), :color => red, :width => 5, :opacity =>  80)
img.polygon(poly.move(150, 75), :color => red, :width => 5, :opacity =>  60)
img.polygon(poly.move(210, 75), :color => red, :width => 5, :opacity =>  40)
img.polygon(poly.move(270, 75), :color => red, :width => 5, :opacity =>  20)

img.polygon(poly.move( 30, 125), nil, :color => blue, :opacity => 100)
img.polygon(poly.move( 90, 125), nil, :color => blue, :opacity =>  80)
img.polygon(poly.move(150, 125), nil, :color => blue, :opacity =>  60)
img.polygon(poly.move(210, 125), nil, :color => blue, :opacity =>  40)
img.polygon(poly.move(270, 125), nil, :color => blue, :opacity =>  20)

img.polygon(poly.move( 30, 175), {:color => red, :width => 3, :pattern => [5, 5], :opacity => 100}, {:color => blue, :opacity => 100})
img.polygon(poly.move( 90, 175), {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  80}, {:color => blue, :opacity =>  80})
img.polygon(poly.move(150, 175), {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  60}, {:color => blue, :opacity =>  60})
img.polygon(poly.move(210, 175), {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  40}, {:color => blue, :opacity =>  40})
img.polygon(poly.move(270, 175), {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  20}, {:color => blue, :opacity =>  20})

img.write_png_file('poly.png')

#==============================================================================#
#==============================================================================#
