#include <assert.h>
#include <gnubversion.h>

#include "gnubversion-nautilus-menu.h"
#include "gnubversion-nautilus-propertypage.h"
#include "gnubversion-nautilus-info.h"
#include "gnubversion-nautilus-column.h"
#include "dirtyhack.h"

GTypeModule *gnubversion_nautilusmodule;

static GType menu_type = 0;
static GType propertypage_type = 0;
static GType info_type = 0;
static GType column_type = 0;

void
nautilus_module_initialize (GTypeModule*module)
{
#ifndef NDEBUG
    printf("Nautilus module initialize\n");
#endif
    gnubversion_nautilusmodule = module;

    gnubversion_init();

    menu_type = gnubversion_nautilus_menu_get_type();
    propertypage_type = gnubversion_nautilus_propertypage_get_type();
    info_type = gnubversion_nautilus_info_get_type();
    column_type = gnubversion_nautilus_column_get_type();
}

void
nautilus_module_shutdown (void)
{
#ifndef NDEBUG
    printf("Nautilus module shutdown\n");
#endif
    gnubversion_shutdown();
}

void 
nautilus_module_list_types (const GType **types,
			    int          *num_types)
{
    static GType type_list[4];
	
#ifndef NDEBUG
    printf("nautilus_module_list_types()\n");
#endif

    int i=0;

    if (menu_type != 0)
        type_list[i++] = menu_type;

    if (propertypage_type != 0)
        type_list[i++] = propertypage_type;

    if (info_type != 0)
        type_list[i++] = info_type;

    if (column_type != 0)
        type_list[i++] = column_type;

    *num_types = i;
    *types = type_list;
}
