#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnubversion.h>
#include <gnome.h>
#include <assert.h>

#define APP_NAME "test-statuswidget"

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    gchar **remaining_args = NULL;

    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    GOptionEntry option_entries[] = 
    {
        /* last but not least a special option that collects filenames */
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          &remaining_args,
          "Special option that collects any remaining arguments for us" },
        { NULL }
    };

    GOptionContext *option_context;
    GnomeProgram *my_app;

    option_context = g_option_context_new ( "" );
    g_option_context_add_main_entries (option_context, option_entries, GETTEXT_PACKAGE);
    g_option_context_add_group( option_context, gnubversion_get_option_group() );

    my_app = gnome_program_init(APP_NAME, VERSION,
                                LIBGNOMEUI_MODULE, argc, argv,
                                GNOME_PARAM_GOPTION_CONTEXT, option_context,
                                GNOME_PARAM_NONE);
    if (remaining_args == NULL)
    {
        g_error("bad parameters");
        gvn_debug("bye bye");
        exit(2);
    }
    gnubversion_init_with_glade(APP_NAME);

    GnubVersionStatusWidget *statuswidget;
    statuswidget = GNUBVERSION_STATUSWIDGET( gnubversion_get_widget("status"));

    GnubVersionStatus * status;
    status = gnubversion_status_new_from_path(remaining_args[0]);

    assert(status != NULL);

    if ( status->status != NULL) 
    {
        gnubversion_statuswidget_populate(statuswidget, status);

        gtk_widget_show (gnubversion_get_widget("window"));

        gtk_main();
    }
    else
    {
    }

    gnubversion_shutdown();
    g_object_unref (my_app);
    return 0;
}
