#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-options.h"

#include <glib/gi18n.h>
#include <assert.h>

static gnubversion_options_t *gnubversion_options = NULL;

static void 
gnubversion_init_options ( void )
{
    if (gnubversion_options != NULL)
        return;

    gnubversion_options_t *opt;

    opt = g_malloc(sizeof(gnubversion_options_t));

    opt->username = g_string_new("");
    opt->password = g_string_new("");
    opt->config_dir = g_string_new("");
    opt->no_auth_cache = FALSE;
    opt->non_interactive = FALSE;

    // Do this last - just in case something goes wrong above
    gnubversion_options = opt;
}

gnubversion_options_t *
gnubversion_get_options ( void )
{
    gnubversion_init_options();
    return gnubversion_options;
}

GOptionGroup *
gnubversion_get_option_group( void )
{
    gnubversion_init_options();
    GOptionEntry option_entries[] = 
    {
        {
            "username", 0,
            0,
            G_OPTION_ARG_STRING,
            gnubversion_options->username,
            _("specify a username"),
            _("username")
        },
        {
            "password", 0,
            0,
            G_OPTION_ARG_STRING,
            gnubversion_options->password,
            _("specify a password (discouraged - may be visible to other users)"),
            _("password")
        },
        {
            "no-auth-cache", 0,
            0, 
            G_OPTION_ARG_NONE,
            &gnubversion_options->no_auth_cache,
            _("do not cache authentication tokens"),
            NULL
        },
        {
            "config-dir", 0,
            0, 
            G_OPTION_ARG_STRING,
            gnubversion_options->config_dir,
            _("read user configuration from directory ARG"),
            _("directory")
        },
        {
            "non-interactive", 0,
            0,
            G_OPTION_ARG_NONE,
            &gnubversion_options->non_interactive,
            _("Do no interactive prompting"),
        },
        { NULL }
    };

    GOptionGroup *optionGroup;

    optionGroup = g_option_group_new( "gnubversion", 
                                    _("GnubVersion Library options:"), 
                                    _("Show GnubVersion options"), 
                                    NULL, 
                                    NULL);

    g_option_group_add_entries(optionGroup, option_entries);

    return optionGroup;
}
