#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gnubversion-private.h"
#include "gnubversion-nodetypekind.h"

#include <glib.h>
#include <glib/gi18n.h>

const char *nodetypekind (svn_node_kind_t kind)
{
    switch (kind)
    {
        case svn_node_none:     return _("absent");
        case svn_node_file:     return _("file");
        case svn_node_dir:      return _("directory");
        case svn_node_unknown:  return _("unknown");
        default:
            g_error(_("Internal Error: unknown svn_node_kind_t value %d"), kind);
            return NULL;
    }
}
