/*
 * Worker thread for gvn add/remove
 *
 * This file contains all of the routines executed directly
 * by the worker thread
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define G_LOG_DOMAIN "worker-thread"

#include "gvn-addremove.h"

#include <assert.h>

static void 
cancel_requested(GnubVersionProgressWindow *progress, gpointer user_data)
{
    gvn_debug("Cancel_requested signal received");
    struct baton *baton = user_data;

    baton->cancel_requested = TRUE;

    GnubVersionThreadMessage *msg;
    msg = gnubversion_threadmessage_new_info(_("Cancelling Update..."));
    gnubversion_progresswindow_send_message(baton->progressWindow, msg);
}

static svn_error_t *
cancel_func( void *svn_baton )
{
    struct baton *baton = svn_baton;

    if ( baton->cancel_requested )
    {
        gvn_debug("Flagging up cancellation");
        return svn_error_create(SVN_ERR_CANCELLED, NULL,
                                "Operation cancelled by user");
    }
    else
        return SVN_NO_ERROR;
}

gpointer 
worker_thread_main( gpointer data )
{
    struct baton *baton = data;
    gvn_debug("thread started");

    baton->cancel_requested = FALSE;
    gnubversion_progresswindow_connect__cancel_requested(baton->progressWindow, cancel_requested, baton);

    gvn_debug("getting filename list");
    apr_array_header_t *targets;
    targets = gnubversion_fileselectorstore_get_ticked_fullnames_apr(baton->store);
    assert(targets != NULL);

    svn_error_t * err = NULL;

    gnubversion_svn_client_ctx->cancel_func = cancel_func;
    gnubversion_svn_client_ctx->cancel_baton = baton;

    gnubversion_svn_client_ctx->notify_func2 = gnubversion_progresswindow_svn_notify2;
    gnubversion_svn_client_ctx->notify_baton2 = baton->progressWindow;

    gvn_debug("working");
    err = do_add_remove(targets, baton);

    gnubversion_svn_client_ctx->cancel_func = NULL;
    gnubversion_svn_client_ctx->notify_func2 = NULL;

    GnubVersionThreadMessage *msg;
    if (err) 
    {
        msg = gnubversion_threadmessage_new_bye_error(g_error_from_svn(err));
    }
    else
    {
        msg = gnubversion_threadmessage_new_bye_success(_("Complete"));
    }
    gnubversion_progresswindow_send_message(baton->progressWindow, msg);

    gvn_debug("bye bye");
    g_free(baton);
    return NULL;
}
