#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define LOG_DOMAIN "gvn-add"

#include <gtk/gtk.h>
#include "gvn-addremove.h"

#define FORCE           GTK_TOGGLE_BUTTON(gnubversion_get_widget("force") )
#define RECURSIVE       GTK_TOGGLE_BUTTON(gnubversion_get_widget("recursive") )
#define IGNORE          GTK_TOGGLE_BUTTON(gnubversion_get_widget("ignore") )

const char *appname = "gvn-add";
const char *appwidget_name = "addApp";
const char *get_initial_progressmessage()
{
    return _("Preparing Add...");
}

const char *get_fileselector_title(void)
{
    return _("Paths to Add:");
}

const char *get_tick_column_title(void)
{
    return _("Add");
}

void set_gui_options(struct baton *baton)
{
    gtk_toggle_button_set_active ( FORCE, baton->force);
    gtk_toggle_button_set_active ( RECURSIVE, !baton->non_recursive);
    gtk_toggle_button_set_active ( IGNORE, !baton->no_ignore);
}

extern void get_gui_options(struct baton *baton)
{
    baton->force = gtk_toggle_button_get_active (FORCE);
    baton->non_recursive = ! gtk_toggle_button_get_active (RECURSIVE);
    baton->no_ignore = ! gtk_toggle_button_get_active (IGNORE);
}

/* Decides which files should be included in the FileSelector */
gboolean include_func (const gchar *path, 
                      svn_wc_status2_t *status, 
                      gpointer user_data)
{
    switch (status->text_status)
    {
        case svn_wc_status_none: /** does not exist */
        case svn_wc_status_normal: /** exists, but uninteresting */
        case svn_wc_status_added: /** is scheduled for addition */
        case svn_wc_status_missing: /** under v.c., but is missing */
        case svn_wc_status_replaced: /** was deleted and then re-added */
        case svn_wc_status_deleted: /** scheduled for deletion */
        case svn_wc_status_modified: /** text or props have been modified */
        case svn_wc_status_merged: /** local mods received repos mods */
        case svn_wc_status_conflicted: /** local mods received conflicting repos mods */
        case svn_wc_status_obstructed: /** an unversioned resource is in the way of the versioned resource */
        case svn_wc_status_external: /** an unversioned path populated by an svn:externals property */
        case svn_wc_status_incomplete: /** a directory doesn't contain a complete entries list */
            return FALSE;
        case svn_wc_status_unversioned: /** is not a versioned thing in this wc */
        case svn_wc_status_ignored: /** is unversioned but configured to be ignored */
            return TRUE;

        default:
            g_warning("Unknown text status %d - ignoring file %p", status->text_status, path);
            return FALSE;
    }
}

GOptionEntry *get_option_entries(
        const gchar ***args,
        struct baton *baton)
{
    GOptionEntry option_entries[] = 
    {
        /* ... your application's command line options go here ... */
        {
            "force", 0,
            0, 
            G_OPTION_ARG_NONE,
            &baton->force,
            _("force operation to run"),
            NULL
        },
        {
            "non-recursive", 'N',
            0, 
            G_OPTION_ARG_NONE,
            &baton->non_recursive,
            _("operate on single directory only"),
            NULL
        },
        {
            "no-ignore", 0,
            0, 
            G_OPTION_ARG_NONE,
            &baton->no_ignore,
            _("disregard default and svn:ignore property ignores"),
            NULL
        },
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          args,
          "Special option that collects any remaining arguments for us" },
        { NULL }
    };

    GOptionEntry *retval = g_malloc(sizeof(option_entries));

    memcpy(retval, option_entries, sizeof(option_entries));

    return retval;
}

svn_error_t * do_add_remove(
    apr_array_header_t *targets,
    struct baton *baton)
{
    svn_error_t *err;
    char **paths;

    int i;
    for (i = 0, paths = (char **)(targets->elts), err = NULL;
        ( i < targets->nelts ) && (err == NULL);
        i++, paths++)
    {
        err = svn_client_add3(*paths,
                              !baton->non_recursive,
                              baton->force,
                              baton->no_ignore,
                              gnubversion_svn_client_ctx,
                              gnubversion_apr_pool);
    }

    return err;
}
