/* Schedule.c generated by valac, the Vala compiler
 * generated from Schedule.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus.h>


#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBEventElementPrivate DVBEventElementPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
typedef struct _DVBSchedulePrivate DVBSchedulePrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	time_t starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	char* name;
	guint duration;
	char* short_description;
};

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	gboolean (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self, GError** error);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id, GError** error);
	gboolean (*GetName) (DVBIDBusSchedule* self, guint32 event_id, char** name, GError** error);
	gboolean (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id, char** description, GError** error);
	gboolean (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id, char** description, GError** error);
	gboolean (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
	gboolean (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
};

struct _DVBSchedule {
	GObject parent_instance;
	DVBSchedulePrivate * priv;
};

struct _DVBScheduleClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBSchedulePrivate {
	DVBChannel* _channel;
	GSequence* events;
	GStaticRecMutex __lock_events;
	GeeMap* event_id_map;
	DVBdatabaseEPGStore* epgstore;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_event_element_parent_class = NULL;
static gpointer dvb_schedule_parent_class = NULL;
static DVBIDBusScheduleIface* dvb_schedule_dvb_id_bus_schedule_parent_iface = NULL;

GType dvb_event_element_get_type (void);
enum  {
	DVB_EVENT_ELEMENT_DUMMY_PROPERTY
};
gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2);
void dvb_event_element_destroy (void* data);
DVBEventElement* dvb_event_element_new (void);
DVBEventElement* dvb_event_element_construct (GType object_type);
static void dvb_event_element_finalize (GObject* obj);
GType dvb_event_info_get_type (void);
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_get_type (void);
GType dvb_schedule_get_type (void);
GType dvb_channel_get_type (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_epg_store_get_type (void);
#define DVB_SCHEDULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCHEDULE, DVBSchedulePrivate))
enum  {
	DVB_SCHEDULE_DUMMY_PROPERTY,
	DVB_SCHEDULE_CHANNEL
};
GeeList* dvb_database_epg_store_get_events (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
DVBChannel* dvb_schedule_get_channel (DVBSchedule* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_channel_get_GroupId (DVBChannel* self);
gboolean dvb_event_has_expired (DVBEvent* self);
static void dvb_schedule_create_and_add_event_element (DVBSchedule* self, DVBEvent* event);
gboolean dvb_database_epg_store_remove_events_older_than (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
static gboolean dvb_schedule_restore (DVBSchedule* self);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
const char* dvb_channel_get_Name (DVBChannel* self);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event);
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event);
GType dvb_database_sqlite_sqlite_database_get_type (void);
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void);
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void);
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void);
gboolean dvb_database_epg_store_add_or_update_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
void dvb_event_get_utc_start_time (DVBEvent* self, struct tm* result);
static gint _dvb_event_element_compare_gcompare_data_func (void* a, void* b, gpointer self);
gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id);
gboolean dvb_event_is_running (DVBEvent* self);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration);
static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error);
static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result);
static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length);
static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error);
static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error);
static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error);
static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error);
static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, char** name, GError** error);
static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, char** description, GError** error);
static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, char** description, GError** error);
static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1);
static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error);
static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error);
static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error);
static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value);
static void _dvb_event_element_destroy_gdestroy_notify (void* data);
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
static gboolean _dvb_schedule_restore_gsource_func (gpointer self);
static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_schedule_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_schedule_introspect (DVBSchedule* self, DBusConnection* connection, DBusMessage* message);
static void dvb_schedule_finalize (GObject* obj);
static void dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_schedule_dbus_path_vtable = {_dvb_schedule_dbus_unregister, dvb_schedule_dbus_message};
static const _DBusObjectVTable _dvb_schedule_dbus_vtable = {dvb_schedule_dbus_register_object};


gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	if (event1 == NULL) {
		_tmp0_ = event2 == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (event1 == NULL) {
			_tmp1_ = event2 != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = +1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (event1 != NULL) {
				_tmp2_ = event2 == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = -1;
				return result;
			}
		}
	}
	if (event1->starttime < event2->starttime) {
		result = -1;
		return result;
	} else {
		if (event1->starttime > event2->starttime) {
			result = +1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_event_element_destroy (void* data) {
	DVBEventElement* e;
	e = _g_object_ref0 (DVB_EVENT_ELEMENT (data));
	g_object_unref (e);
	_g_object_unref0 (e);
}


DVBEventElement* dvb_event_element_construct (GType object_type) {
	DVBEventElement * self;
	self = (DVBEventElement*) g_object_new (object_type, NULL);
	return self;
}


DVBEventElement* dvb_event_element_new (void) {
	return dvb_event_element_construct (DVB_TYPE_EVENT_ELEMENT);
}


static void dvb_event_element_class_init (DVBEventElementClass * klass) {
	dvb_event_element_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dvb_event_element_finalize;
}


static void dvb_event_element_instance_init (DVBEventElement * self) {
}


static void dvb_event_element_finalize (GObject* obj) {
	DVBEventElement * self;
	self = DVB_EVENT_ELEMENT (obj);
	G_OBJECT_CLASS (dvb_event_element_parent_class)->finalize (obj);
}


GType dvb_event_element_get_type (void) {
	static volatile gsize dvb_event_element_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventElement), 0, (GInstanceInitFunc) dvb_event_element_instance_init, NULL };
		GType dvb_event_element_type_id;
		dvb_event_element_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventElement", &g_define_type_info, 0);
		g_once_init_leave (&dvb_event_element_type_id__volatile, dvb_event_element_type_id);
	}
	return dvb_event_element_type_id__volatile;
}


static gboolean dvb_schedule_restore (DVBSchedule* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	GeeList* levents;
	gint newest_expired;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	levents = NULL;
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		_tmp0_ = dvb_database_epg_store_get_events (self->priv->epgstore, dvb_channel_get_Sid (self->priv->_channel), dvb_channel_get_GroupId (self->priv->_channel), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch153_dvb_database_sql_error;
			}
			_g_object_unref0 (levents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		levents = (_tmp1_ = _tmp0_, _g_object_unref0 (levents), _tmp1_);
	}
	goto __finally153;
	__catch153_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Schedule.vala:80: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (levents);
			return result;
		}
	}
	__finally153:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (levents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	newest_expired = -1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				DVBEvent* event;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < gee_collection_get_size ((GeeCollection*) levents))) {
					break;
				}
				event = (DVBEvent*) gee_list_get (levents, i);
				if (dvb_event_has_expired (event)) {
					newest_expired = i;
				} else {
					dvb_schedule_create_and_add_event_element (self, event);
				}
				_dvb_event_unref0 (event);
			}
		}
	}
	if (newest_expired != (-1)) {
		DVBEvent* event;
		event = (DVBEvent*) gee_list_get (levents, newest_expired);
		{
			dvb_database_epg_store_remove_events_older_than (self->priv->epgstore, event, dvb_channel_get_Sid (self->priv->_channel), dvb_channel_get_GroupId (self->priv->_channel), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch154_dvb_database_sql_error;
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (levents);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally154;
		__catch154_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("Schedule.vala:101: %s", e->message);
				result = FALSE;
				_g_error_free0 (e);
				_dvb_event_unref0 (event);
				_g_object_unref0 (levents);
				return result;
			}
		}
		__finally154:
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (event);
			_g_object_unref0 (levents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_dvb_event_unref0 (event);
	}
	g_debug ("Schedule.vala:106: Finished restoring EPG events for channel %u", dvb_channel_get_Sid (self->priv->_channel));
	result = FALSE;
	_g_object_unref0 (levents);
	return result;
}


DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel) {
	DVBSchedule * self;
	g_return_val_if_fail (channel != NULL, NULL);
	self = (DVBSchedule*) g_object_new (object_type, "channel", channel, NULL);
	return self;
}


DVBSchedule* dvb_schedule_new (DVBChannel* channel) {
	return dvb_schedule_construct (DVB_TYPE_SCHEDULE, channel);
}


void dvb_schedule_remove_expired_events (DVBSchedule* self) {
	GError * _inner_error_;
	GSList* expired_events;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	expired_events = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			GSList* last_iter;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						GSequenceIter* iter;
						DVBEventElement* element;
						DVBEvent* e;
						gboolean _tmp1_ = FALSE;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < g_sequence_get_length (self->priv->events))) {
							break;
						}
						iter = g_sequence_get_iter_at_pos (self->priv->events, i);
						element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
						e = dvb_schedule_get_event (self, element->id);
						if (e != NULL) {
							_tmp1_ = dvb_event_has_expired (e);
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							expired_events = g_slist_prepend (expired_events, iter);
						} else {
							_g_object_unref0 (element);
							_dvb_event_unref0 (e);
							break;
						}
						_g_object_unref0 (element);
						_dvb_event_unref0 (e);
					}
				}
			}
			g_debug ("Schedule.vala:133: Removing expired events of channel %s (%u)", dvb_channel_get_Name (self->priv->_channel), dvb_channel_get_Sid (self->priv->_channel));
			last_iter = g_slist_last (expired_events);
			if (last_iter != NULL) {
				DVBEventElement* element;
				DVBEvent* event;
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get ((GSequenceIter*) last_iter->data));
				event = dvb_schedule_get_event (self, element->id);
				{
					dvb_database_epg_store_remove_events_older_than (self->priv->epgstore, event, dvb_channel_get_Sid (self->priv->_channel), dvb_channel_get_GroupId (self->priv->_channel), &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch156_dvb_database_sql_error;
						}
						_g_object_unref0 (element);
						_dvb_event_unref0 (event);
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_events);
						}
						_g_slist_free0 (expired_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally156;
				__catch156_dvb_database_sql_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_critical ("Schedule.vala:145: %s", e->message);
						_g_error_free0 (e);
					}
				}
				__finally156:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (element);
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					_dvb_event_unref0 (event);
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
					}
					_g_slist_free0 (expired_events);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			}
			{
				GSList* iter_collection;
				GSList* iter_it;
				iter_collection = expired_events;
				for (iter_it = iter_collection; iter_it != NULL; iter_it = iter_it->next) {
					GSequenceIter* iter;
					iter = (GSequenceIter*) iter_it->data;
					{
						DVBEventElement* element;
						element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
						gee_map_remove (self->priv->event_id_map, GUINT_TO_POINTER (element->id), NULL);
						g_sequence_remove (iter);
						_g_object_unref0 (element);
					}
				}
			}
		}
		__finally155:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			_g_slist_free0 (expired_events);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_slist_free0 (expired_events);
}


DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	{
		DVBEvent* _tmp0_;
		_tmp0_ = dvb_database_epg_store_get_event (self->priv->epgstore, event_id, dvb_channel_get_Sid (self->priv->_channel), dvb_channel_get_GroupId (self->priv->_channel), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch157_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally157;
	__catch157_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Schedule.vala:163: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally157:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void dvb_schedule_add (DVBSchedule* self, DVBEvent* event) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_inner_error_ = NULL;
	if (dvb_event_has_expired (event)) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			dvb_schedule_store_event (self, event);
		}
		__finally158:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_events != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				dvb_database_sqlite_sqlite_database_begin_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (self->priv->epgstore), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch160_dvb_database_sql_error;
					}
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally160;
			__catch160_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_critical ("Schedule.vala:184: %s", e->message);
					_g_error_free0 (e);
				}
			}
			__finally160:
			if (_inner_error_ != NULL) {
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_events);
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			{
				GeeIterator* _event_it;
				_event_it = gee_iterable_iterator ((GeeIterable*) new_events);
				while (TRUE) {
					DVBEvent* event;
					if (!gee_iterator_next (_event_it)) {
						break;
					}
					event = (DVBEvent*) gee_iterator_get (_event_it);
					if (!dvb_event_has_expired (event)) {
						dvb_schedule_store_event (self, event);
					}
					_dvb_event_unref0 (event);
				}
				_g_object_unref0 (_event_it);
			}
			{
				dvb_database_sqlite_sqlite_database_end_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (self->priv->epgstore), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch161_dvb_database_sql_error;
					}
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally161;
			__catch161_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_critical ("Schedule.vala:193: %s", e->message);
					_g_error_free0 (e);
				}
			}
			__finally161:
			if (_inner_error_ != NULL) {
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_events);
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		__finally159:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_inner_error_ = NULL;
	if (!gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER (event->id))) {
		dvb_schedule_create_and_add_event_element (self, event);
	}
	{
		dvb_database_epg_store_add_or_update_event (self->priv->epgstore, event, dvb_channel_get_Sid (self->priv->_channel), dvb_channel_get_GroupId (self->priv->_channel), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch162_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally162;
	__catch162_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Schedule.vala:207: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally162:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gint _dvb_event_element_compare_gcompare_data_func (void* a, void* b, gpointer self) {
	gint result;
	result = dvb_event_element_compare (a, b);
	return result;
}


static void dvb_schedule_create_and_add_event_element (DVBSchedule* self, DVBEvent* event) {
	DVBEventElement* element;
	struct tm _tmp0_ = {0};
	struct tm utc_starttime;
	GSequenceIter* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	element = dvb_event_element_new ();
	element->id = event->id;
	utc_starttime = (dvb_event_get_utc_start_time (event, &_tmp0_), _tmp0_);
	element->starttime = mktime (&utc_starttime);
	iter = g_sequence_insert_sorted (self->priv->events, _g_object_ref0 (element), _dvb_event_element_compare_gcompare_data_func, NULL);
	gee_map_set (self->priv->event_id_map, GUINT_TO_POINTER (event->id), iter);
	g_assert (g_sequence_get_length (self->priv->events) == gee_map_get_size (self->priv->event_id_map));
	_g_object_unref0 (element);
}


gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			val = gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER (event_id));
		}
		__finally163:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static gpointer _dvb_event_ref0 (gpointer self) {
	return self ? dvb_event_ref (self) : NULL;
}


DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self) {
	DVBEvent* result = NULL;
	GError * _inner_error_;
	DVBEvent* running_event;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	running_event = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						GSequenceIter* iter;
						DVBEventElement* element;
						DVBEvent* event;
						gboolean _tmp1_ = FALSE;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < g_sequence_get_length (self->priv->events))) {
							break;
						}
						iter = g_sequence_get_iter_at_pos (self->priv->events, i);
						element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
						event = dvb_schedule_get_event (self, element->id);
						if (event != NULL) {
							_tmp1_ = dvb_event_is_running (event);
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							DVBEvent* _tmp2_;
							running_event = (_tmp2_ = _dvb_event_ref0 (event), _dvb_event_unref0 (running_event), _tmp2_);
							_g_object_unref0 (element);
							_dvb_event_unref0 (event);
							break;
						}
						_g_object_unref0 (element);
						_dvb_event_unref0 (event);
					}
				}
			}
		}
		__finally164:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (running_event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = running_event;
	return result;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration) {
	DVBEvent* result = NULL;
	GError * _inner_error_;
	DVBEvent* _result_;
	time_t timer_start;
	time_t timer_end;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = NULL;
	timer_start = mktime (start);
	timer_end = timer_start + (duration * 60);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			time_t last_diff;
			last_diff = (time_t) 0;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						GSequenceIter* iter;
						DVBEventElement* element;
						struct tm _tmp2_;
						struct tm _tmp1_ = {0};
						time_t event_start;
						DVBEvent* event;
						time_t event_end;
						time_t _tmp3_;
						time_t min_end;
						time_t _tmp4_;
						time_t max_start;
						time_t overlap;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < g_sequence_get_length (self->priv->events))) {
							break;
						}
						iter = g_sequence_get_iter_at_pos (self->priv->events, i);
						element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
						event_start = timegm ((_tmp2_ = (g_time_local (element->starttime, &_tmp1_), _tmp1_), &_tmp2_));
						event = dvb_schedule_get_event (self, element->id);
						if (event == NULL) {
							_g_object_unref0 (element);
							_dvb_event_unref0 (event);
							continue;
						}
						event_end = event_start + event->duration;
						if (timer_end < event_end) {
							_tmp3_ = timer_end;
						} else {
							_tmp3_ = event_end;
						}
						min_end = _tmp3_;
						if (timer_start > event_start) {
							_tmp4_ = timer_start;
						} else {
							_tmp4_ = event_start;
						}
						max_start = _tmp4_;
						overlap = min_end - max_start;
						if (last_diff < overlap) {
							DVBEvent* _tmp5_;
							last_diff = overlap;
							_result_ = (_tmp5_ = _dvb_event_ref0 (event), _dvb_event_unref0 (_result_), _tmp5_);
						}
						if (event_start > timer_end) {
							_g_object_unref0 (element);
							_dvb_event_unref0 (event);
							break;
						}
						_g_object_unref0 (element);
						_dvb_event_unref0 (event);
					}
				}
			}
		}
		__finally165:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	guint32* result = NULL;
	GError * _inner_error_;
	GeeArrayList* events;
	guint32* _tmp3_;
	gint _event_ids_size_;
	gint event_ids_length1;
	gint _tmp2_;
	guint32* event_ids;
	guint32* _tmp5_;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	events = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						GSequenceIter* iter;
						DVBEventElement* element;
						DVBEvent* event;
						gboolean _tmp1_ = FALSE;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < g_sequence_get_length (self->priv->events))) {
							break;
						}
						iter = g_sequence_get_iter_at_pos (self->priv->events, i);
						element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
						event = dvb_schedule_get_event (self, element->id);
						if (event == NULL) {
							_tmp1_ = TRUE;
						} else {
							_tmp1_ = dvb_event_has_expired (event);
						}
						if (_tmp1_) {
							_g_object_unref0 (element);
							_dvb_event_unref0 (event);
							continue;
						}
						gee_abstract_collection_add ((GeeAbstractCollection*) events, GUINT_TO_POINTER ((guint32) element->id));
						_g_object_unref0 (element);
						_dvb_event_unref0 (event);
					}
				}
			}
		}
		__finally166:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	event_ids = (_tmp3_ = g_new0 (guint32, _tmp2_ = gee_collection_get_size ((GeeCollection*) events)), event_ids_length1 = _tmp2_, _event_ids_size_ = event_ids_length1, _tmp3_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < event_ids_length1)) {
					break;
				}
				event_ids[i] = GPOINTER_TO_UINT (gee_abstract_list_get ((GeeAbstractList*) events, i));
			}
		}
	}
	result = (_tmp5_ = event_ids, *result_length1 = event_ids_length1, _tmp5_);
	_g_object_unref0 (events);
	return result;
	_g_object_unref0 (events);
	event_ids = (g_free (event_ids), NULL);
}


static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_event_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	DVBEventInfo* result = NULL;
	GError * _inner_error_;
	GeeArrayList* events;
	gint n_events;
	DVBEventInfo* _tmp2_;
	gint _event_infos_size_;
	gint event_infos_length1;
	DVBEventInfo* event_infos;
	gint i;
	DVBEvent* event;
	DVBEventInfo* _tmp8_;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	events = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			GSequenceIter* iter;
			iter = g_sequence_get_begin_iter (self->priv->events);
			if (!g_sequence_iter_is_end (iter)) {
				DVBEventElement* element;
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				while (TRUE) {
					DVBEvent* event;
					gboolean _tmp0_ = FALSE;
					if (!(!g_sequence_iter_is_end (iter))) {
						break;
					}
					event = dvb_schedule_get_event (self, element->id);
					if (event != NULL) {
						_tmp0_ = !dvb_event_has_expired (event);
					} else {
						_tmp0_ = FALSE;
					}
					if (_tmp0_) {
						gee_abstract_collection_add ((GeeAbstractCollection*) events, event);
					}
					iter = g_sequence_iter_next (iter);
					if (!g_sequence_iter_is_end (iter)) {
						DVBEventElement* _tmp1_;
						element = (_tmp1_ = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter)), _g_object_unref0 (element), _tmp1_);
					}
					_dvb_event_unref0 (event);
				}
				_g_object_unref0 (element);
			}
		}
		__finally167:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	n_events = gee_collection_get_size ((GeeCollection*) events);
	event_infos = (_tmp2_ = g_new0 (DVBEventInfo, n_events), event_infos_length1 = n_events, _event_infos_size_ = event_infos_length1, _tmp2_);
	i = 0;
	event = NULL;
	if (n_events > i) {
		DVBEvent* _tmp3_;
		event = (_tmp3_ = (DVBEvent*) gee_abstract_list_get ((GeeAbstractList*) events, i), _dvb_event_unref0 (event), _tmp3_);
	}
	while (TRUE) {
		DVBEventInfo _tmp5_;
		DVBEventInfo _tmp4_ = {0};
		if (!(event != NULL)) {
			break;
		}
		event_infos[i] = (_tmp5_ = (dvb_schedule_event_to_event_info (event, &_tmp4_), _tmp4_), dvb_event_info_destroy (&event_infos[i]), _tmp5_);
		if ((i + 1) == n_events) {
			DVBEvent* _tmp6_;
			event_infos[i].next = (guint32) 0;
			event = (_tmp6_ = NULL, _dvb_event_unref0 (event), _tmp6_);
		} else {
			DVBEvent* _tmp7_;
			event = (_tmp7_ = (DVBEvent*) gee_abstract_list_get ((GeeAbstractList*) events, i + 1), _dvb_event_unref0 (event), _tmp7_);
			event_infos[i].next = (guint32) event->id;
		}
		i++;
	}
	result = (_tmp8_ = event_infos, *result_length1 = event_infos_length1, _tmp8_);
	_g_object_unref0 (events);
	_dvb_event_unref0 (event);
	return result;
	_g_object_unref0 (events);
	event_infos = (_vala_DVBEventInfo_array_free (event_infos, event_infos_length1), NULL);
	_dvb_event_unref0 (event);
}


static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret = FALSE;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				DVBEventInfo _tmp1_;
				DVBEventInfo _tmp0_ = {0};
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				*event_info = (_tmp1_ = (dvb_schedule_event_to_event_info (event, &_tmp0_), _tmp0_), dvb_event_info_destroy (event_info), _tmp1_);
				iter = g_sequence_iter_next (iter);
				if (g_sequence_iter_is_end (iter)) {
					(*event_info).next = (guint32) 0;
				} else {
					DVBEventElement* _tmp2_;
					element = (_tmp2_ = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter)), _g_object_unref0 (element), _tmp2_);
					(*event_info).next = (guint32) element->id;
				}
				ret = TRUE;
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				char* _tmp3_;
				char* _tmp4_;
				(*event_info).id = (guint32) 0;
				(*event_info).name = (_tmp3_ = g_strdup (""), _g_free0 ((*event_info).name), _tmp3_);
				(*event_info).duration = (guint) 0;
				(*event_info).short_description = (_tmp4_ = g_strdup (""), _g_free0 ((*event_info).short_description), _tmp4_);
				(*event_info).next = (guint32) 0;
				ret = FALSE;
			}
		}
		__finally168:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	DVBEvent* event;
	guint _tmp0_ = 0U;
	self = (DVBSchedule*) base;
	event = dvb_schedule_get_running_event (self);
	if (event == NULL) {
		_tmp0_ = (guint) 0;
	} else {
		_tmp0_ = event->id;
	}
	result = (guint32) _tmp0_;
	_dvb_event_unref0 (event);
	return result;
}


static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	GError * _inner_error_;
	guint32 next_event;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	next_event = (guint32) 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				GSequenceIter* next_iter;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				next_iter = g_sequence_iter_next (iter);
				if (!g_sequence_iter_is_end (next_iter)) {
					DVBEventElement* element;
					element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (next_iter));
					next_event = (guint32) element->id;
					_g_object_unref0 (element);
				}
			} else {
				g_debug ("Schedule.vala:405: No event with id %u", (guint) event_id);
			}
		}
		__finally169:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return 0U;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
	}
	result = next_event;
	return result;
}


static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, char** name, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	if (name != NULL) {
		*name = NULL;
	}
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				gboolean _tmp0_ = FALSE;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					_tmp0_ = event->name != NULL;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					char* _tmp1_;
					*name = (_tmp1_ = g_strdup (event->name), _g_free0 (*name), _tmp1_);
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				g_debug ("Schedule.vala:425: No event with id %u", (guint) event_id);
			}
		}
		__finally170:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp2_;
		*name = (_tmp2_ = g_strdup (""), _g_free0 (*name), _tmp2_);
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, char** description, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	if (description != NULL) {
		*description = NULL;
	}
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				gboolean _tmp0_ = FALSE;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					_tmp0_ = event->description != NULL;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					char* _tmp1_;
					*description = (_tmp1_ = g_strdup (event->description), _g_free0 (*description), _tmp1_);
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				g_debug ("Schedule.vala:447: No event with id %u", (guint) event_id);
			}
		}
		__finally171:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp2_;
		*description = (_tmp2_ = g_strdup (""), _g_free0 (*description), _tmp2_);
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, char** description, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	if (description != NULL) {
		*description = NULL;
	}
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				gboolean _tmp0_ = FALSE;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					_tmp0_ = event->extended_description != NULL;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					char* _tmp1_;
					*description = (_tmp1_ = g_strdup (event->extended_description), _g_free0 (*description), _tmp1_);
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				g_debug ("Schedule.vala:469: No event with id %u", (guint) event_id);
			}
		}
		__finally172:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp2_;
		*description = (_tmp2_ = g_strdup (""), _g_free0 (*description), _tmp2_);
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					*duration = event->duration;
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				g_debug ("Schedule.vala:491: No event with id %u", (guint) event_id);
			}
		}
		__finally173:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	if (start_time != NULL) {
		*start_time = NULL;
	}
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					struct tm _tmp0_ = {0};
					struct tm local_time;
					guint* _tmp2_;
					gint _tmp1_;
					local_time = (dvb_event_get_local_start_time (event, &_tmp0_), _tmp0_);
					*start_time = (_tmp2_ = dvb_schedule_to_time_array (&local_time, &_tmp1_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = _tmp1_, _tmp2_);
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				guint* _tmp4_;
				guint* _tmp3_ = NULL;
				g_debug ("Schedule.vala:514: No event with id %u", (guint) event_id);
				*start_time = (_tmp4_ = (_tmp3_ = g_new0 (guint, 0), _tmp3_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = 0, _tmp4_);
			}
		}
		__finally174:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		guint* _tmp5_;
		*start_time = (_tmp5_ = g_new0 (guint, 0), *start_time = (g_free (*start_time), NULL), *start_time_length1 = 0, _tmp5_);
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					struct tm _tmp0_ = {0};
					struct tm local_time;
					local_time = (dvb_event_get_local_start_time (event, &_tmp0_), _tmp0_);
					*timestamp = (gint64) mktime (&local_time);
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			}
		}
		__finally175:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					*running = dvb_event_is_running (event);
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				g_debug ("Schedule.vala:558: No event with id %u", (guint) event_id);
			}
		}
		__finally176:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error) {
	DVBSchedule * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBSchedule*) base;
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
				GSequenceIter* iter;
				DVBEventElement* element;
				DVBEvent* event;
				iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
				element = _g_object_ref0 ((DVBEventElement*) g_sequence_get (iter));
				event = dvb_schedule_get_event (self, element->id);
				if (event != NULL) {
					*scrambled = !event->free_ca_mode;
					ret = TRUE;
				}
				_g_object_unref0 (element);
				_dvb_event_unref0 (event);
			} else {
				g_debug ("Schedule.vala:580: No event with id %u", (guint) event_id);
			}
		}
		__finally177:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1) {
	guint* result = NULL;
	guint* _tmp0_;
	gint _start_size_;
	gint start_length1;
	guint* start;
	guint* _tmp1_;
	start = (_tmp0_ = g_new0 (guint, 6), start_length1 = 6, _start_size_ = start_length1, _tmp0_);
	start[0] = (guint) ((*local_time).tm_year + 1900);
	start[1] = (guint) ((*local_time).tm_mon + 1);
	start[2] = (guint) (*local_time).tm_mday;
	start[3] = (guint) (*local_time).tm_hour;
	start[4] = (guint) (*local_time).tm_min;
	start[5] = (guint) (*local_time).tm_sec;
	result = (_tmp1_ = start, *result_length1 = start_length1, _tmp1_);
	return result;
	start = (g_free (start), NULL);
}


static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result) {
	DVBEventInfo event_info = {0};
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (event != NULL);
	memset (&event_info, 0, sizeof (DVBEventInfo));
	event_info.id = (guint32) event->id;
	event_info.name = (_tmp0_ = g_strdup (event->name), _g_free0 (event_info.name), _tmp0_);
	event_info.duration = event->duration;
	event_info.short_description = (_tmp1_ = g_strdup (event->description), _g_free0 (event_info.short_description), _tmp1_);
	*result = event_info;
	return;
}


DVBChannel* dvb_schedule_get_channel (DVBSchedule* self) {
	DVBChannel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channel;
	return result;
}


static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value) {
	g_return_if_fail (self != NULL);
	self->priv->_channel = value;
	g_object_notify ((GObject *) self, "channel");
}


static void _dvb_event_element_destroy_gdestroy_notify (void* data) {
	dvb_event_element_destroy (data);
}


static gboolean _dvb_schedule_restore_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_schedule_restore (self);
	return result;
}


static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSchedule * self;
	parent_class = G_OBJECT_CLASS (dvb_schedule_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCHEDULE (obj);
	{
		GSequence* _tmp0_;
		GeeMap* _tmp1_;
		DVBdatabaseEPGStore* _tmp2_;
		self->priv->events = (_tmp0_ = g_sequence_new (_dvb_event_element_destroy_gdestroy_notify), _g_sequence_free0 (self->priv->events), _tmp0_);
		self->priv->event_id_map = (_tmp1_ = (GeeMap*) gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->event_id_map), _tmp1_);
		self->priv->epgstore = (_tmp2_ = dvb_factory_get_epg_store (), _g_object_unref0 (self->priv->epgstore), _tmp2_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _dvb_schedule_restore_gsource_func, g_object_ref (self), g_object_unref);
	}
	return obj;
}


void _dvb_schedule_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_schedule_introspect (DVBSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Schedule\">\n  <method name=\"GetAllEvents\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllEventInfos\">\n    <arg name=\"result\" type=\"a(uusus)\" direction=\"out\"/>\n  </method>\n  <method name=\"GetInformations\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"event_info\" type=\"(uusus)\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"NowPlaying\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"Next\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetShortDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetExtendedDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTime\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTimestamp\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timestamp\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRunning\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"running\" type=\"b\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsScrambled\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"scrambled\" type=\"b\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_schedule_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_schedule_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_schedule_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_schedule_dbus_register_object (connection, path, object);
}


static void dvb_schedule_class_init (DVBScheduleClass * klass) {
	dvb_schedule_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSchedulePrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_schedule_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_schedule_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_schedule_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_schedule_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCHEDULE_CHANNEL, g_param_spec_object ("channel", "channel", "channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_type_set_qdata (DVB_TYPE_SCHEDULE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_schedule_dbus_vtable));
}


static void dvb_schedule_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface * iface) {
	dvb_schedule_dvb_id_bus_schedule_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetAllEvents = dvb_schedule_real_GetAllEvents;
	iface->GetAllEventInfos = dvb_schedule_real_GetAllEventInfos;
	iface->GetInformations = dvb_schedule_real_GetInformations;
	iface->NowPlaying = dvb_schedule_real_NowPlaying;
	iface->Next = dvb_schedule_real_Next;
	iface->GetName = dvb_schedule_real_GetName;
	iface->GetShortDescription = dvb_schedule_real_GetShortDescription;
	iface->GetExtendedDescription = dvb_schedule_real_GetExtendedDescription;
	iface->GetDuration = dvb_schedule_real_GetDuration;
	iface->GetLocalStartTime = dvb_schedule_real_GetLocalStartTime;
	iface->GetLocalStartTimestamp = dvb_schedule_real_GetLocalStartTimestamp;
	iface->IsRunning = dvb_schedule_real_IsRunning;
	iface->IsScrambled = dvb_schedule_real_IsScrambled;
}


static void dvb_schedule_instance_init (DVBSchedule * self) {
	self->priv = DVB_SCHEDULE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_events);
}


static void dvb_schedule_finalize (GObject* obj) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_events);
	_g_sequence_free0 (self->priv->events);
	_g_object_unref0 (self->priv->event_id_map);
	_g_object_unref0 (self->priv->epgstore);
	G_OBJECT_CLASS (dvb_schedule_parent_class)->finalize (obj);
}


GType dvb_schedule_get_type (void) {
	static volatile gsize dvb_schedule_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_schedule_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScheduleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_schedule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSchedule), 0, (GInstanceInitFunc) dvb_schedule_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_schedule_info = { (GInterfaceInitFunc) dvb_schedule_dvb_id_bus_schedule_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_schedule_type_id;
		dvb_schedule_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSchedule", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_schedule_type_id, DVB_TYPE_ID_BUS_SCHEDULE, &dvb_id_bus_schedule_info);
		g_once_init_leave (&dvb_schedule_type_id__volatile, dvb_schedule_type_id);
	}
	return dvb_schedule_type_id__volatile;
}


static void dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		g_value_set_object (value, dvb_schedule_get_channel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		dvb_schedule_set_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




