/* Recorder.c generated by valac, the Vala compiler
 * generated from Recorder.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <gst/gst.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

#define DVB_TYPE_TIMER_INFO (dvb_timer_info_get_type ())
typedef struct _DVBTimerInfo DVBTimerInfo;

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;
typedef struct _DVBRecorderPrivate DVBRecorderPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBTimerInfo {
	guint32 id;
	guint duration;
	gboolean active;
	char* channel_name;
	char* title;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	gboolean (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
	gboolean (*SetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
	gboolean (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
	gboolean (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
	gboolean (*SetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id, char** name, GError** error);
	gboolean (*GetTitle) (DVBIDBusRecorder* self, guint32 timer_id, char** title, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
};

struct _DVBRecorder {
	GObject parent_instance;
	DVBRecorderPrivate * priv;
};

struct _DVBRecorderClass {
	GObjectClass parent_class;
};

struct _DVBRecorderPrivate {
	DVBDeviceGroup* _DeviceGroup;
	GeeSet* active_timers;
	gboolean have_check_timers_timeout;
	guint check_timers_event_id;
	GeeHashMap* timers;
	GStaticRecMutex __lock_timers;
	GeeMap* recordings;
	GStaticRecMutex __lock_recordings;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_recorder_parent_class = NULL;
static DVBIDBusRecorderIface* dvb_recorder_dvb_id_bus_recorder_parent_iface = NULL;
static GeeIterableIface* dvb_recorder_gee_iterable_parent_iface = NULL;

GType dvb_timer_info_get_type (void);
DVBTimerInfo* dvb_timer_info_dup (const DVBTimerInfo* self);
void dvb_timer_info_free (DVBTimerInfo* self);
void dvb_timer_info_copy (const DVBTimerInfo* self, DVBTimerInfo* dest);
void dvb_timer_info_destroy (DVBTimerInfo* self);
GType dvb_overlap_type_get_type (void);
GType dvb_id_bus_recorder_get_type (void);
GType dvb_recorder_get_type (void);
GType dvb_device_group_get_type (void);
GType dvb_timer_get_type (void);
GType dvb_recording_get_type (void);
#define DVB_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDER, DVBRecorderPrivate))
enum  {
	DVB_RECORDER_DUMMY_PROPERTY,
	DVB_RECORDER_DEVICE_GROUP,
	DVB_RECORDER_COUNT,
	DVB_RECORDER_ELEMENT_TYPE
};
#define DVB_RECORDER_CHECK_TIMERS_INTERVAL 5
#define DVB_RECORDER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE
DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev);
DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev);
static GeeIterator* dvb_recorder_real_iterator (GeeIterable* base);
DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id);
static gboolean dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
GType dvb_settings_get_type (void);
DVBSettings* dvb_factory_get_settings (void);
gint dvb_settings_get_integer (DVBSettings* self, const char* group_name, const char* key, GError** error);
#define DVB_SETTINGS_TIMERS_SECTION "timers"
#define DVB_SETTINGS_MARGIN_START "margin_start"
#define DVB_SETTINGS_MARGIN_END "margin_end"
guint dvb_timer_get_Duration (DVBTimer* self);
void dvb_timer_set_Duration (DVBTimer* self, guint value);
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes);
static gboolean dvb_recorder_real_AddTimerWithMargin (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
gboolean dvb_timer_has_expired (DVBTimer* self);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
char* dvb_timer_to_string (DVBTimer* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_timers_store_get_type (void);
DVBdatabaseTimersStore* dvb_factory_get_timers_store (void);
gboolean dvb_database_timers_store_add_timer_to_device_group (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
GType dvb_change_type_get_type (void);
static gboolean dvb_recorder_check_timers (DVBRecorder* self);
static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
GType dvb_database_epg_store_get_type (void);
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
gboolean dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void);
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void);
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void);
static gboolean dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
gboolean dvb_recorder_delete_timer (DVBRecorder* self, guint32 timer_id);
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id, GError** error);
gboolean dvb_recorder_is_timer_active (DVBRecorder* self, guint32 timer_id);
void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer);
gboolean dvb_database_timers_store_remove_timer_from_device_group (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1, GError** error);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
static gboolean dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute);
static gboolean dvb_recorder_real_SetStartTime (DVBIDBusRecorder* base, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
static gboolean dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
static gboolean dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint* duration, GError** error);
static gboolean dvb_recorder_real_SetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint duration, GError** error);
GType dvb_channel_get_type (void);
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
const char* dvb_channel_get_Name (DVBChannel* self);
static gboolean dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id, char** name, GError** error);
GType dvb_schedule_get_type (void);
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
guint dvb_timer_get_EventID (DVBTimer* self);
static gboolean dvb_recorder_real_GetTitle (DVBIDBusRecorder* base, guint32 timer_id, char** title, GError** error);
static gboolean dvb_recorder_real_GetAllInformations (DVBIDBusRecorder* base, guint32 timer_id, DVBTimerInfo* info, GError** error);
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1, GError** error);
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id, GError** error);
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_recorder_real_HasTimerForEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, GError** error);
void dvb_recorder_stop (DVBRecorder* self);
GType dvb_channel_list_get_type (void);
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
GType dvb_recordings_store_get_type (void);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1);
void dvb_timer_set_sink (DVBTimer* self, GstElement* value);
GType dvb_channel_factory_get_type (void);
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
GType dvb_player_thread_get_type (void);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
static void dvb_recorder_on_eit_structure (DVBRecorder* self, DVBPlayerThread* player, const GstStructure* structure);
static void _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure (DVBPlayerThread* _sender, const GstStructure* structure, gpointer self);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
void dvb_recording_set_ChannelName (DVBRecording* self, const char* value);
void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_recording_set_Name (DVBRecording* self, const char* value);
void dvb_recording_set_Description (DVBRecording* self, const char* value);
guint32 dvb_recording_get_Id (DVBRecording* self);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
gint64 dvb_recording_get_Length (DVBRecording* self);
void dvb_recording_save_to_disk (DVBRecording* self);
GstElement* dvb_timer_get_sink (DVBTimer* self);
void dvb_recording_monitor_recording (DVBRecording* self);
char* dvb_utils_remove_nonalphanums (const char* text);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
gboolean dvb_timer_is_end_due (DVBTimer* self);
gboolean dvb_timer_is_start_due (DVBTimer* self);
static void _g_slist_free_g_object_unref (GSList* self);
const char* dvb_recording_get_Name (DVBRecording* self);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value);
guint dvb_recorder_get_count (DVBRecorder* self);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_recorder_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_recorder_introspect (DVBRecorder* self, DBusConnection* connection, DBusMessage* message);
static void dvb_recorder_finalize (GObject* obj);
static void dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_recorder_dbus_path_vtable = {_dvb_recorder_dbus_unregister, dvb_recorder_dbus_message};
static const _DBusObjectVTable _dvb_recorder_dbus_vtable = {dvb_recorder_dbus_register_object};


DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev) {
	DVBRecorder * self;
	g_return_val_if_fail (dev != NULL, NULL);
	self = (DVBRecorder*) g_object_new (object_type, "DeviceGroup", dev, NULL);
	return self;
}


DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev) {
	return dvb_recorder_construct (DVB_TYPE_RECORDER, dev);
}


static GeeIterator* dvb_recorder_real_iterator (GeeIterable* base) {
	DVBRecorder * self;
	GeeIterator* result = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	self = (DVBRecorder*) base;
	result = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->timers))), _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


static gboolean dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	DVBTimer* new_timer;
	self = (DVBRecorder*) base;
	new_timer = dvb_recorder_create_timer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	if (new_timer == NULL) {
		*timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (new_timer);
		return result;
	} else {
		result = dvb_recorder_add_timer (self, new_timer, timer_id);
		_g_object_unref0 (new_timer);
		return result;
	}
	_g_object_unref0 (new_timer);
}


static gboolean dvb_recorder_real_AddTimerWithMargin (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBTimer* new_timer;
	DVBSettings* settings;
	gint start_margin;
	guint end_margin;
	gboolean ret;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	new_timer = dvb_recorder_create_timer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	if (new_timer == NULL) {
		*timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (new_timer);
		return result;
	}
	settings = dvb_factory_get_settings ();
	start_margin = 0;
	end_margin = (guint) 0;
	{
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = dvb_settings_get_integer (settings, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_START, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch98_g_key_file_error;
			}
			_g_object_unref0 (new_timer);
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		start_margin = (-1) * _tmp0_;
		_tmp1_ = dvb_settings_get_integer (settings, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_END, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch98_g_key_file_error;
			}
			_g_object_unref0 (new_timer);
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		end_margin = 2 * ((guint) _tmp1_);
		dvb_timer_set_Duration (new_timer, dvb_timer_get_Duration (new_timer) + end_margin);
		dvb_timer_add_to_start_time (new_timer, start_margin);
	}
	goto __finally98;
	__catch98_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Recorder.vala:133: Could not retrieve start/end margins: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally98:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (new_timer);
			_g_object_unref0 (settings);
			return FALSE;
		} else {
			_g_object_unref0 (new_timer);
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	ret = TRUE;
	if (!dvb_recorder_add_timer (self, new_timer, timer_id)) {
		dvb_timer_set_Duration (new_timer, dvb_timer_get_Duration (new_timer) - end_margin);
		dvb_timer_add_to_start_time (new_timer, (-1) * start_margin);
		ret = dvb_recorder_add_timer (self, new_timer, timer_id);
	}
	result = ret;
	_g_object_unref0 (new_timer);
	_g_object_unref0 (settings);
	return result;
}


static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_recorder_check_timers (self);
	return result;
}


gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_timer != NULL, FALSE);
	_inner_error_ = NULL;
	if (dvb_timer_has_expired (new_timer)) {
		result = FALSE;
		return result;
	}
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			gboolean has_conflict;
			gint conflict_count;
			has_conflict = FALSE;
			conflict_count = 0;
			{
				GeeSet* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _key_it;
				_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->timers))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					guint32 key;
					DVBTimer* _tmp2_;
					gboolean _tmp3_;
					if (!gee_iterator_next (_key_it)) {
						break;
					}
					key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
					if ((_tmp3_ = dvb_timer_conflicts_with (_tmp2_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key)), new_timer), _g_object_unref0 (_tmp2_), _tmp3_)) {
						conflict_count++;
						if (conflict_count >= dvb_device_group_get_size (self->priv->_DeviceGroup)) {
							char* _tmp5_;
							DVBTimer* _tmp4_;
							g_debug ("Recorder.vala:161: Timer is conflicting with another timer: %s", _tmp5_ = dvb_timer_to_string (_tmp4_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key))));
							_g_free0 (_tmp5_);
							_g_object_unref0 (_tmp4_);
							has_conflict = TRUE;
							break;
						}
					}
				}
				_g_object_unref0 (_key_it);
			}
			if (!has_conflict) {
				gboolean _tmp7_ = FALSE;
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (dvb_timer_get_Id (new_timer)), new_timer);
				{
					DVBdatabaseTimersStore* _tmp6_;
					dvb_database_timers_store_add_timer_to_device_group (_tmp6_ = dvb_factory_get_timers_store (), new_timer, self->priv->_DeviceGroup, &_inner_error_);
					_g_object_unref0 (_tmp6_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch100_dvb_database_sql_error;
						}
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_timers);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				goto __finally100;
				__catch100_dvb_database_sql_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_critical ("Recorder.vala:175: %s", e->message);
						_g_error_free0 (e);
					}
				}
				__finally100:
				if (_inner_error_ != NULL) {
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_timers);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", dvb_timer_get_Id (new_timer), (guint) DVB_CHANGE_TYPE_ADDED);
				if (gee_map_get_size ((GeeMap*) self->priv->timers) == 1) {
					_tmp7_ = !self->priv->have_check_timers_timeout;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					g_debug ("Recorder.vala:180: Creating new check timers");
					self->priv->check_timers_event_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) DVB_RECORDER_CHECK_TIMERS_INTERVAL, _dvb_recorder_check_timers_gsource_func, g_object_ref (self), g_object_unref);
					self->priv->have_check_timers_timeout = TRUE;
				}
				*timer_id = dvb_timer_get_Id (new_timer);
				ret = TRUE;
			}
		}
		__finally99:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBdatabaseEPGStore* epgstore;
	DVBEvent* event;
	struct tm _tmp2_ = {0};
	struct tm start;
	gboolean _tmp3_;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	epgstore = dvb_factory_get_epg_store ();
	event = NULL;
	{
		DVBEvent* _tmp0_;
		DVBEvent* _tmp1_;
		_tmp0_ = dvb_database_epg_store_get_event (epgstore, event_id, channel_sid, dvb_device_group_get_Id (self->priv->_DeviceGroup), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch101_dvb_database_sql_error;
			}
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		event = (_tmp1_ = _tmp0_, _dvb_event_unref0 (event), _tmp1_);
	}
	goto __finally101;
	__catch101_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Recorder.vala:209: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally101:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			return FALSE;
		} else {
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (event == NULL) {
		g_debug ("Recorder.vala:212: Could not find event with id %u", event_id);
		*timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (epgstore);
		_dvb_event_unref0 (event);
		return result;
	}
	start = (dvb_event_get_local_start_time (event, &_tmp2_), _tmp2_);
	_tmp3_ = dvb_id_bus_recorder_AddTimerWithMargin ((DVBIDBusRecorder*) self, channel_sid, start.tm_year + 1900, start.tm_mon + 1, start.tm_mday, start.tm_hour, start.tm_min, event->duration / 60, timer_id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			return FALSE;
		} else {
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp3_;
	_g_object_unref0 (epgstore);
	_dvb_event_unref0 (event);
	return result;
}


static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	self = (DVBRecorder*) base;
	result = dvb_recorder_delete_timer (self, timer_id);
	return result;
}


gboolean dvb_recorder_delete_timer (DVBRecorder* self, guint32 timer_id) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				if (dvb_recorder_is_timer_active (self, timer_id)) {
					DVBTimer* timer;
					timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
					dvb_recorder_stop_recording (self, timer);
					_g_object_unref0 (timer);
				}
				gee_map_remove ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id), NULL);
				{
					DVBdatabaseTimersStore* _tmp0_;
					dvb_database_timers_store_remove_timer_from_device_group (_tmp0_ = dvb_factory_get_timers_store (), (guint) timer_id, self->priv->_DeviceGroup, &_inner_error_);
					_g_object_unref0 (_tmp0_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch103_dvb_database_sql_error;
						}
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_timers);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				goto __finally103;
				__catch103_dvb_database_sql_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_critical ("Recorder.vala:249: %s", e->message);
						_g_error_free0 (e);
					}
				}
				__finally103:
				if (_inner_error_ != NULL) {
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_timers);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
				val = TRUE;
			} else {
				val = FALSE;
			}
		}
		__finally102:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1, GError** error) {
	DVBRecorder * self;
	guint32* result = NULL;
	GError * _inner_error_;
	gint _timer_arr_size_;
	gint timer_arr_length1;
	guint32* timer_arr;
	guint32* _tmp5_;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	timer_arr = (timer_arr_length1 = 0, NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			guint32* _tmp1_;
			gint _tmp0_;
			gint i;
			timer_arr = (_tmp1_ = g_new0 (guint32, _tmp0_ = gee_map_get_size ((GeeMap*) self->priv->timers)), timer_arr = (g_free (timer_arr), NULL), timer_arr_length1 = _tmp0_, _timer_arr_size_ = timer_arr_length1, _tmp1_);
			i = 0;
			{
				GeeSet* _tmp2_;
				GeeIterator* _tmp3_;
				GeeIterator* _key_it;
				_key_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->timers))), _g_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					guint32 key;
					DVBTimer* _tmp4_;
					if (!gee_iterator_next (_key_it)) {
						break;
					}
					key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
					timer_arr[i] = dvb_timer_get_Id (_tmp4_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key)));
					_g_object_unref0 (_tmp4_);
					i++;
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally104:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				timer_arr = (g_free (timer_arr), NULL);
				return NULL;
			} else {
				timer_arr = (g_free (timer_arr), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = (_tmp5_ = timer_arr, *result_length1 = timer_arr_length1, _tmp5_);
	return result;
	timer_arr = (g_free (timer_arr), NULL);
}


static gboolean dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret = FALSE;
	self = (DVBRecorder*) base;
	if (start_time != NULL) {
		*start_time = NULL;
	}
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				guint32* _tmp2_;
				gint _tmp1_;
				DVBTimer* _tmp0_;
				*start_time = (_tmp2_ = dvb_timer_get_start_time (_tmp0_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id)), &_tmp1_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = _tmp1_, _tmp2_);
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			} else {
				guint32* _tmp4_;
				guint* _tmp3_ = NULL;
				*start_time = (_tmp4_ = (_tmp3_ = g_new0 (guint, 0), _tmp3_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = 0, _tmp4_);
				ret = FALSE;
			}
		}
		__finally105:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_SetStartTime (DVBIDBusRecorder* base, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				gboolean _tmp0_;
				_tmp0_ = dvb_id_bus_recorder_IsTimerActive ((DVBIDBusRecorder*) self, timer_id, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __finally106;
				}
				if (_tmp0_) {
					g_warning ("Recorder.vala:319: Cannot change start time of already active timer");
				} else {
					DVBTimer* timer;
					timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
					dvb_timer_set_start_time (timer, start_year, start_month, start_day, start_hour, start_minute);
					ret = TRUE;
					_g_object_unref0 (timer);
				}
			}
		}
		__finally106:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (ret) {
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_UPDATED);
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret = FALSE;
	self = (DVBRecorder*) base;
	if (end_time != NULL) {
		*end_time = NULL;
	}
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				guint* _tmp2_;
				gint _tmp1_;
				DVBTimer* _tmp0_;
				*end_time = (_tmp2_ = dvb_timer_get_end_time (_tmp0_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id)), &_tmp1_), *end_time = (g_free (*end_time), NULL), *end_time_length1 = _tmp1_, _tmp2_);
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			} else {
				guint* _tmp4_;
				guint* _tmp3_ = NULL;
				*end_time = (_tmp4_ = (_tmp3_ = g_new0 (guint, 0), _tmp3_), *end_time = (g_free (*end_time), NULL), *end_time_length1 = 0, _tmp4_);
				ret = FALSE;
			}
		}
		__finally107:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint* duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				DVBTimer* _tmp0_;
				*duration = dvb_timer_get_Duration (_tmp0_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id)));
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			}
		}
		__finally108:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_SetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret = FALSE;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			ret = gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			if (ret) {
				DVBTimer* timer;
				timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				dvb_timer_set_Duration (timer, duration);
				_g_object_unref0 (timer);
			}
		}
		__finally109:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (ret) {
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_UPDATED);
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id, char** name, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret = FALSE;
	self = (DVBRecorder*) base;
	if (name != NULL) {
		*name = NULL;
	}
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				DVBTimer* t;
				char* _tmp0_;
				t = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				*name = (_tmp0_ = g_strdup (dvb_channel_get_Name (dvb_timer_get_Channel (t))), _g_free0 (*name), _tmp0_);
				ret = TRUE;
				_g_object_unref0 (t);
			} else {
				char* _tmp1_;
				*name = (_tmp1_ = g_strdup (""), _g_free0 (*name), _tmp1_);
				ret = FALSE;
			}
		}
		__finally110:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static gboolean dvb_recorder_real_GetTitle (DVBIDBusRecorder* base, guint32 timer_id, char** title, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	self = (DVBRecorder*) base;
	if (title != NULL) {
		*title = NULL;
	}
	_inner_error_ = NULL;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				DVBTimer* t;
				DVBEvent* event;
				const char* _tmp0_;
				char* _tmp1_;
				t = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				event = dvb_schedule_get_event (dvb_channel_get_Schedule (dvb_timer_get_Channel (t)), dvb_timer_get_EventID (t));
				_tmp0_ = NULL;
				if (event == NULL) {
					_tmp0_ = "";
				} else {
					_tmp0_ = event->name;
				}
				*title = (_tmp1_ = g_strdup (_tmp0_), _g_free0 (*title), _tmp1_);
				ret = TRUE;
				_g_object_unref0 (t);
				_dvb_event_unref0 (event);
			}
		}
		__finally111:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp2_;
		*title = (_tmp2_ = g_strdup (""), _g_free0 (*title), _tmp2_);
	}
	result = ret;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean dvb_recorder_real_GetAllInformations (DVBIDBusRecorder* base, guint32 timer_id, DVBTimerInfo* info, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBTimerInfo _tmp1_;
	DVBTimerInfo _tmp0_ = {0};
	gboolean ret = FALSE;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	*info = (_tmp1_ = (memset (&_tmp0_, 0, sizeof (DVBTimerInfo)), _tmp0_), dvb_timer_info_destroy (info), _tmp1_);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
				DVBTimer* t;
				DVBChannel* chan;
				char* _tmp2_;
				DVBEvent* event;
				t = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				(*info).id = timer_id;
				(*info).duration = dvb_timer_get_Duration (t);
				(*info).active = gee_collection_contains ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (timer_id));
				chan = _g_object_ref0 (dvb_timer_get_Channel (t));
				(*info).channel_name = (_tmp2_ = g_strdup (dvb_channel_get_Name (chan)), _g_free0 ((*info).channel_name), _tmp2_);
				event = dvb_schedule_get_event (dvb_channel_get_Schedule (chan), dvb_timer_get_EventID (t));
				if (event != NULL) {
					char* _tmp3_;
					(*info).title = (_tmp3_ = g_strdup (event->name), _g_free0 ((*info).title), _tmp3_);
				} else {
					char* _tmp4_;
					(*info).title = (_tmp4_ = g_strdup (""), _g_free0 ((*info).title), _tmp4_);
				}
				ret = TRUE;
				_g_object_unref0 (t);
				_g_object_unref0 (chan);
				_dvb_event_unref0 (event);
			} else {
				char* _tmp5_;
				char* _tmp6_;
				(*info).id = (guint32) 0;
				(*info).duration = (guint) 0;
				(*info).active = FALSE;
				(*info).channel_name = (_tmp5_ = g_strdup (""), _g_free0 ((*info).channel_name), _tmp5_);
				(*info).title = (_tmp6_ = g_strdup (""), _g_free0 ((*info).title), _tmp6_);
				ret = FALSE;
			}
		}
		__finally112:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1, GError** error) {
	DVBRecorder * self;
	guint32* result = NULL;
	guint32* _tmp1_;
	gint _val_size_;
	gint val_length1;
	gint _tmp0_;
	guint32* val;
	gint i;
	guint32* _tmp2_;
	self = (DVBRecorder*) base;
	val = (_tmp1_ = g_new0 (guint32, _tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->active_timers)), val_length1 = _tmp0_, _val_size_ = val_length1, _tmp1_);
	i = 0;
	{
		GeeIterator* _timer_id_it;
		_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->priv->active_timers);
		while (TRUE) {
			guint32 timer_id;
			DVBTimer* timer;
			if (!gee_iterator_next (_timer_id_it)) {
				break;
			}
			timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
			timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			val[i] = dvb_timer_get_Id (timer);
			i++;
			_g_object_unref0 (timer);
		}
		_g_object_unref0 (_timer_id_it);
	}
	result = (_tmp2_ = val, *result_length1 = val_length1, _tmp2_);
	return result;
	val = (g_free (val), NULL);
}


static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	self = (DVBRecorder*) base;
	result = dvb_recorder_is_timer_active (self, timer_id);
	return result;
}


gboolean dvb_recorder_is_timer_active (DVBRecorder* self, guint32 timer_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gee_collection_contains ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (timer_id));
	return result;
}


static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	val = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			{
				GeeSet* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _key_it;
				_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->timers))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					guint32 key;
					DVBTimer* _tmp2_;
					DVBOverlapType _tmp3_;
					DVBOverlapType overlap;
					gboolean _tmp4_ = FALSE;
					if (!gee_iterator_next (_key_it)) {
						break;
					}
					key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
					overlap = (_tmp3_ = dvb_timer_get_overlap_local (_tmp2_ = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key)), start_year, start_month, start_day, start_hour, start_minute, duration), _g_object_unref0 (_tmp2_), _tmp3_);
					if (overlap == DVB_OVERLAP_TYPE_PARTIAL) {
						_tmp4_ = TRUE;
					} else {
						_tmp4_ = overlap == DVB_OVERLAP_TYPE_COMPLETE;
					}
					if (_tmp4_) {
						val = TRUE;
						break;
					}
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally113:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = val;
	return result;
}


static DVBOverlapType dvb_recorder_real_HasTimerForEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, GError** error) {
	DVBRecorder * self;
	DVBOverlapType result = 0;
	GError * _inner_error_;
	DVBdatabaseEPGStore* epgstore;
	DVBEvent* event;
	DVBOverlapType val;
	self = (DVBRecorder*) base;
	_inner_error_ = NULL;
	epgstore = dvb_factory_get_epg_store ();
	event = NULL;
	{
		DVBEvent* _tmp0_;
		DVBEvent* _tmp1_;
		_tmp0_ = dvb_database_epg_store_get_event (epgstore, event_id, channel_sid, dvb_device_group_get_Id (self->priv->_DeviceGroup), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch114_dvb_database_sql_error;
			}
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		event = (_tmp1_ = _tmp0_, _dvb_event_unref0 (event), _tmp1_);
	}
	goto __finally114;
	__catch114_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Recorder.vala:542: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally114:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			return 0;
		} else {
			_g_object_unref0 (epgstore);
			_dvb_event_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (event == NULL) {
		g_debug ("Recorder.vala:545: Could not find event with id %u", event_id);
		result = DVB_OVERLAP_TYPE_UNKNOWN;
		_g_object_unref0 (epgstore);
		_dvb_event_unref0 (event);
		return result;
	}
	val = DVB_OVERLAP_TYPE_NONE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			{
				GeeSet* _tmp2_;
				GeeIterator* _tmp3_;
				GeeIterator* _key_it;
				_key_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->timers))), _g_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					guint32 key;
					DVBTimer* timer;
					if (!gee_iterator_next (_key_it)) {
						break;
					}
					key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
					timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
					if (dvb_channel_get_Sid (dvb_timer_get_Channel (timer)) == channel_sid) {
						DVBOverlapType overlap;
						gboolean _tmp4_ = FALSE;
						overlap = dvb_timer_get_overlap_utc (timer, event->year, event->month, event->day, event->hour, event->minute, event->duration / 60);
						if (overlap == DVB_OVERLAP_TYPE_PARTIAL) {
							_tmp4_ = TRUE;
						} else {
							_tmp4_ = overlap == DVB_OVERLAP_TYPE_COMPLETE;
						}
						if (_tmp4_) {
							val = overlap;
							_g_object_unref0 (timer);
							break;
						}
					}
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally115:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (epgstore);
				_dvb_event_unref0 (event);
				return 0;
			} else {
				_g_object_unref0 (epgstore);
				_dvb_event_unref0 (event);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = val;
	_g_object_unref0 (epgstore);
	_dvb_event_unref0 (event);
	return result;
}


void dvb_recorder_stop (DVBRecorder* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->check_timers_event_id > 0) {
		g_source_remove (self->priv->check_timers_event_id);
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			{
				GeeIterator* _timer_id_it;
				_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->priv->active_timers);
				while (TRUE) {
					guint32 timer_id;
					DVBTimer* timer;
					if (!gee_iterator_next (_timer_id_it)) {
						break;
					}
					timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
					timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
					dvb_recorder_stop_recording (self, timer);
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_timer_id_it);
			}
		}
		__finally116:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DVBTimer* result = NULL;
	DVBChannelList* channels;
	guint32 timer_id;
	DVBChannel* _tmp0_;
	DVBTimer* _tmp1_;
	DVBTimer* new_timer;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("Recorder.vala:585: Creating new timer: channel: %u, start: %04d-%02d-%" \
"02d %02d:%02d, duration: %u", channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	channels = _g_object_ref0 (dvb_device_group_get_Channels (self->priv->_DeviceGroup));
	if (!dvb_channel_list_contains (channels, channel)) {
		g_warning ("Recorder.vala:591: No channel %u for device group %u", channel, dvb_device_group_get_Id (self->priv->_DeviceGroup));
		result = NULL;
		_g_object_unref0 (channels);
		return result;
	}
	timer_id = dvb_recordings_store_get_next_id (dvb_recordings_store_get_instance ());
	new_timer = (_tmp1_ = dvb_timer_new (timer_id, _tmp0_ = dvb_channel_list_get_channel (dvb_device_group_get_Channels (self->priv->_DeviceGroup), channel), start_year, start_month, start_day, start_hour, start_minute, duration), _g_object_unref0 (_tmp0_), _tmp1_);
	result = new_timer;
	_g_object_unref0 (channels);
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure (DVBPlayerThread* _sender, const GstStructure* structure, gpointer self) {
	dvb_recorder_on_eit_structure (self, _sender, structure);
}


void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer) {
	GError * _inner_error_;
	DVBChannel* channel;
	guint* _tmp2_;
	gint _tmp1__length1;
	guint* _tmp1_;
	gint _tmp0_;
	GFile* _tmp3_;
	GFile* location;
	GstElement* filesink;
	char* _tmp4_;
	DVBChannelFactory* channel_factory;
	DVBPlayerThread* player;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	_inner_error_ = NULL;
	channel = _g_object_ref0 (dvb_timer_get_Channel (timer));
	location = (_tmp3_ = (_tmp2_ = (_tmp1_ = dvb_timer_get_start_time (timer, &_tmp0_), _tmp1__length1 = _tmp0_, _tmp1_), dvb_recorder_create_recording_dirs (self, channel, _tmp2_, _tmp0_)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp3_);
	if (location == NULL) {
		_g_object_unref0 (channel);
		_g_object_unref0 (location);
		return;
	}
	filesink = gst_element_factory_make ("filesink", NULL);
	if (filesink == NULL) {
		g_critical ("Recorder.vala:617: Could not create filesink element");
		_g_object_unref0 (channel);
		_g_object_unref0 (location);
		_gst_object_unref0 (filesink);
		return;
	}
	g_object_set ((GObject*) filesink, "location", _tmp4_ = g_file_get_path (location), NULL);
	_g_free0 (_tmp4_);
	dvb_timer_set_sink (timer, filesink);
	channel_factory = _g_object_ref0 (dvb_device_group_get_channel_factory (self->priv->_DeviceGroup));
	player = dvb_channel_factory_watch_channel (channel_factory, channel, _gst_object_ref0 (filesink), TRUE, NULL, NULL);
	if (player != NULL) {
		GstElement* _tmp5_;
		GstStateChangeReturn _tmp6_;
		GstStateChangeReturn ret;
		DVBRecording* recording;
		struct tm _tmp7_ = {0};
		struct tm _tmp8_;
		g_debug ("Recorder.vala:627: Setting pipeline to playing");
		ret = (_tmp6_ = gst_element_set_state (_tmp5_ = dvb_player_thread_get_pipeline (player), GST_STATE_PLAYING), _gst_object_unref0 (_tmp5_), _tmp6_);
		if (ret == GST_STATE_CHANGE_FAILURE) {
			g_critical ("Recorder.vala:631: Failed setting pipeline to playing");
			dvb_channel_factory_stop_channel (channel_factory, channel, filesink);
			_g_object_unref0 (channel);
			_g_object_unref0 (location);
			_gst_object_unref0 (filesink);
			_g_object_unref0 (channel_factory);
			_g_object_unref0 (player);
			return;
		}
		g_signal_connect_object (player, "eit-structure", (GCallback) _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure, self, 0);
		recording = dvb_recording_new ();
		dvb_recording_set_Id (recording, dvb_timer_get_Id (timer));
		dvb_recording_set_ChannelSid (recording, dvb_channel_get_Sid (channel));
		dvb_recording_set_ChannelName (recording, dvb_channel_get_Name (channel));
		dvb_recording_set_StartTime (recording, (_tmp8_ = (dvb_timer_get_start_time_time (timer, &_tmp7_), _tmp7_), &_tmp8_));
		dvb_recording_set_Location (recording, location);
		dvb_recording_set_Name (recording, NULL);
		dvb_recording_set_Description (recording, NULL);
		if (dvb_timer_get_EventID (timer) != 0) {
			DVBEvent* event;
			event = dvb_schedule_get_event (dvb_channel_get_Schedule (channel), dvb_timer_get_EventID (timer));
			if (event != NULL) {
				char* _tmp9_;
				g_debug ("Recorder.vala:652: Transfering event information from timer");
				dvb_recording_set_Name (recording, event->name);
				dvb_recording_set_Description (recording, _tmp9_ = g_strdup_printf ("%s\n%s", event->description, event->extended_description));
				_g_free0 (_tmp9_);
			}
			_dvb_event_unref0 (event);
		}
		{
			g_static_rec_mutex_lock (&self->priv->__lock_recordings);
			{
				gee_map_set (self->priv->recordings, GUINT_TO_POINTER ((guint) dvb_recording_get_Id (recording)), recording);
			}
			__finally117:
			{
				g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
			}
			if (_inner_error_ != NULL) {
				_g_object_unref0 (recording);
				_g_object_unref0 (channel);
				_g_object_unref0 (location);
				_gst_object_unref0 (filesink);
				_g_object_unref0 (channel_factory);
				_g_object_unref0 (player);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		dvb_recordings_store_add (dvb_recordings_store_get_instance (), recording);
		_g_object_unref0 (recording);
	}
	gee_collection_add ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (dvb_timer_get_Id (timer)));
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-started", dvb_timer_get_Id (timer));
	_g_object_unref0 (channel);
	_g_object_unref0 (location);
	_gst_object_unref0 (filesink);
	_g_object_unref0 (channel_factory);
	_g_object_unref0 (player);
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer) {
	GError * _inner_error_;
	DVBRecording* rec;
	guint32 timer_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	_inner_error_ = NULL;
	rec = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			DVBRecording* _tmp0_;
			struct tm _tmp4_;
			struct tm _tmp3_;
			struct tm _tmp1_ = {0};
			struct tm _tmp2_ = {0};
			DVBChannelFactory* channel_factory;
			rec = (_tmp0_ = (DVBRecording*) gee_map_get (self->priv->recordings, GUINT_TO_POINTER ((guint) dvb_timer_get_Id (timer))), _g_object_unref0 (rec), _tmp0_);
			dvb_recording_set_Length (rec, (gint64) dvb_utils_difftime ((_tmp3_ = (g_time_local (time (NULL), &_tmp1_), _tmp1_), &_tmp3_), (_tmp4_ = (dvb_recording_get_StartTime (rec, &_tmp2_), _tmp2_), &_tmp4_)));
			g_debug ("Recording of channel %s stopped after %" G_GINT64_FORMAT " seconds", dvb_recording_get_ChannelName (rec), dvb_recording_get_Length (rec));
			dvb_recording_save_to_disk (rec);
			channel_factory = _g_object_ref0 (dvb_device_group_get_channel_factory (self->priv->_DeviceGroup));
			dvb_channel_factory_stop_channel (channel_factory, dvb_timer_get_Channel (timer), dvb_timer_get_sink (timer));
			gee_map_remove (self->priv->recordings, GUINT_TO_POINTER ((guint) dvb_timer_get_Id (timer)), NULL);
			_g_object_unref0 (channel_factory);
		}
		__finally118:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (rec);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	timer_id = dvb_timer_get_Id (timer);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			gee_collection_remove ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (timer_id));
			gee_map_remove ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id), NULL);
		}
		__finally119:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (rec);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_recording_monitor_recording (rec);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-finished", dvb_recording_get_Id (rec));
	_g_object_unref0 (rec);
}


static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1) {
	GFile* result = NULL;
	GError * _inner_error_;
	char* channel_name;
	char* time;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
	GFileInfo* info;
	GFile* recording;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_inner_error_ = NULL;
	channel_name = dvb_utils_remove_nonalphanums (dvb_channel_get_Name (channel));
	time = g_strdup_printf ("%u-%u-%u_%u-%u", start[0], start[1], start[2], start[3], start[4]);
	dir = (_tmp1_ = g_file_get_child (_tmp0_ = g_file_get_child (dvb_device_group_get_RecordingsDirectory (self->priv->_DeviceGroup), channel_name), time), _g_object_unref0 (_tmp0_), _tmp1_);
	if (!g_file_query_exists (dir, NULL)) {
		{
			dvb_utils_mkdirs (dir, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch120_g_error;
			}
		}
		goto __finally120;
		__catch120_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp2_;
				g_error ("Recorder.vala:722: Could not create directory %s: %s", _tmp2_ = g_file_get_path (dir), e->message);
				_g_free0 (_tmp2_);
				result = NULL;
				_g_error_free0 (e);
				_g_free0 (channel_name);
				_g_free0 (time);
				_g_object_unref0 (dir);
				return result;
			}
		}
		__finally120:
		if (_inner_error_ != NULL) {
			_g_free0 (channel_name);
			_g_free0 (time);
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	info = NULL;
	{
		GFileInfo* _tmp3_;
		GFileInfo* _tmp4_;
		_tmp3_ = g_file_query_info (dir, DVB_RECORDER_ATTRIBUTES, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch121_g_error;
		}
		info = (_tmp4_ = _tmp3_, _g_object_unref0 (info), _tmp4_);
	}
	goto __finally121;
	__catch121_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Recorder.vala:732: Could not retrieve attributes: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			_g_free0 (channel_name);
			_g_free0 (time);
			_g_object_unref0 (dir);
			_g_object_unref0 (info);
			return result;
		}
	}
	__finally121:
	if (_inner_error_ != NULL) {
		_g_free0 (channel_name);
		_g_free0 (time);
		_g_object_unref0 (dir);
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_STANDARD_TYPE) != G_FILE_TYPE_DIRECTORY) {
		char* _tmp5_;
		g_critical ("Recorder.vala:738: %s is not a directory", _tmp5_ = g_file_get_path (dir));
		_g_free0 (_tmp5_);
		result = NULL;
		_g_free0 (channel_name);
		_g_free0 (time);
		_g_object_unref0 (dir);
		_g_object_unref0 (info);
		return result;
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE)) {
		char* _tmp6_;
		g_critical ("Recorder.vala:743: Cannot write to %s", _tmp6_ = g_file_get_path (dir));
		_g_free0 (_tmp6_);
		result = NULL;
		_g_free0 (channel_name);
		_g_free0 (time);
		_g_object_unref0 (dir);
		_g_object_unref0 (info);
		return result;
	}
	recording = g_file_get_child (dir, "001.mpeg");
	if (g_file_query_exists (recording, NULL)) {
		char* _tmp7_;
		g_warning ("Recorder.vala:749: Recording %s already exists", _tmp7_ = g_file_get_path (recording));
		_g_free0 (_tmp7_);
		result = NULL;
		_g_free0 (channel_name);
		_g_free0 (time);
		_g_object_unref0 (dir);
		_g_object_unref0 (info);
		_g_object_unref0 (recording);
		return result;
	}
	result = recording;
	_g_free0 (channel_name);
	_g_free0 (time);
	_g_object_unref0 (dir);
	_g_object_unref0 (info);
	return result;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static gboolean dvb_recorder_check_timers (DVBRecorder* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val = FALSE;
	GSList* ended_recordings;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	g_debug ("Recorder.vala:756: Checking timers");
	ended_recordings = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GSList* deleteable_items;
			gboolean _tmp7_ = FALSE;
			{
				GeeIterator* _timer_id_it;
				_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->priv->active_timers);
				while (TRUE) {
					guint32 timer_id;
					DVBTimer* timer;
					if (!gee_iterator_next (_timer_id_it)) {
						break;
					}
					timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
					timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
					if (dvb_timer_is_end_due (timer)) {
						ended_recordings = g_slist_prepend (ended_recordings, _g_object_ref0 (timer));
					}
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_timer_id_it);
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						DVBTimer* timer;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < g_slist_length (ended_recordings))) {
							break;
						}
						timer = _g_object_ref0 ((DVBTimer*) g_slist_nth_data (ended_recordings, (guint) i));
						dvb_recorder_stop_recording (self, timer);
						_g_object_unref0 (timer);
					}
				}
			}
			deleteable_items = NULL;
			{
				GeeSet* _tmp1_;
				GeeIterator* _tmp2_;
				GeeIterator* _key_it;
				_key_it = (_tmp2_ = gee_iterable_iterator ((GeeIterable*) (_tmp1_ = gee_map_get_keys ((GeeMap*) self->priv->timers))), _g_object_unref0 (_tmp1_), _tmp2_);
				while (TRUE) {
					guint32 key;
					DVBTimer* timer;
					char* _tmp3_;
					gboolean _tmp4_ = FALSE;
					if (!gee_iterator_next (_key_it)) {
						break;
					}
					key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
					timer = (DVBTimer*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
					g_debug ("Recorder.vala:782: Checking timer: %s", _tmp3_ = dvb_timer_to_string (timer));
					_g_free0 (_tmp3_);
					if (dvb_timer_is_start_due (timer)) {
						_tmp4_ = !gee_collection_contains ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (dvb_timer_get_Id (timer)));
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						dvb_recorder_start_recording (self, timer);
					} else {
						if (dvb_timer_has_expired (timer)) {
							char* _tmp5_;
							g_debug ("Recorder.vala:790: Removing expired timer: %s", _tmp5_ = dvb_timer_to_string (timer));
							_g_free0 (_tmp5_);
							deleteable_items = g_slist_prepend (deleteable_items, GUINT_TO_POINTER (key));
						}
					}
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_key_it);
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp6_;
					_tmp6_ = TRUE;
					while (TRUE) {
						if (!_tmp6_) {
							i++;
						}
						_tmp6_ = FALSE;
						if (!(i < g_slist_length (deleteable_items))) {
							break;
						}
						dvb_recorder_delete_timer (self, GPOINTER_TO_UINT (g_slist_nth_data (deleteable_items, (guint) i)));
					}
				}
			}
			if (gee_map_get_size ((GeeMap*) self->priv->timers) == 0) {
				_tmp7_ = gee_collection_get_size ((GeeCollection*) self->priv->active_timers) == 0;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				g_debug ("Recorder.vala:802: No timers left and no recording in progress");
				self->priv->have_check_timers_timeout = FALSE;
				self->priv->check_timers_event_id = (guint) 0;
				val = FALSE;
			} else {
				g_debug ("Recorder.vala:808: %d timers and %d active recordings left", gee_map_get_size ((GeeMap*) self->priv->timers), gee_collection_get_size ((GeeCollection*) self->priv->active_timers));
				val = TRUE;
			}
			_g_slist_free0 (deleteable_items);
		}
		__finally122:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (_inner_error_ != NULL) {
			__g_slist_free_g_object_unref0 (ended_recordings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	__g_slist_free_g_object_unref0 (ended_recordings);
	return result;
}


static void dvb_recorder_on_eit_structure (DVBRecorder* self, DVBPlayerThread* player, const GstStructure* structure) {
	GError * _inner_error_;
	guint sid = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (structure != NULL);
	_inner_error_ = NULL;
	gst_structure_get_uint (structure, "service-id", &sid);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			{
				GeeCollection* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _rec_it;
				_rec_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values (self->priv->recordings))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					DVBRecording* rec;
					gboolean _tmp2_ = FALSE;
					if (!gee_iterator_next (_rec_it)) {
						break;
					}
					rec = (DVBRecording*) gee_iterator_get (_rec_it);
					if (dvb_recording_get_Name (rec) == NULL) {
						_tmp2_ = sid == dvb_recording_get_ChannelSid (rec);
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						DVBChannel* chan;
						DVBSchedule* sched;
						DVBEvent* event;
						chan = dvb_channel_list_get_channel (dvb_device_group_get_Channels (self->priv->_DeviceGroup), sid);
						sched = _g_object_ref0 (dvb_channel_get_Schedule (chan));
						event = dvb_schedule_get_running_event (sched);
						if (event != NULL) {
							char* _tmp3_;
							g_debug ("Recorder.vala:830: Found running event for active recording");
							dvb_recording_set_Name (rec, event->name);
							dvb_recording_set_Description (rec, _tmp3_ = g_strdup_printf ("%s\n%s", event->description, event->extended_description));
							_g_free0 (_tmp3_);
						}
						_g_object_unref0 (chan);
						_g_object_unref0 (sched);
						_dvb_event_unref0 (event);
					}
					_g_object_unref0 (rec);
				}
				_g_object_unref0 (_rec_it);
			}
		}
		__finally123:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self) {
	DVBDeviceGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_DeviceGroup;
	return result;
}


static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value) {
	g_return_if_fail (self != NULL);
	self->priv->_DeviceGroup = value;
	g_object_notify ((GObject *) self, "DeviceGroup");
}


guint dvb_recorder_get_count (DVBRecorder* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) gee_map_get_size (self->priv->recordings);
	return result;
}


static GType dvb_recorder_real_get_element_type (GeeIterable* base) {
	GType result;
	DVBRecorder* self;
	self = (DVBRecorder*) base;
	result = DVB_TYPE_TIMER;
	return result;
}


static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecorder * self;
	parent_class = G_OBJECT_CLASS (dvb_recorder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDER (obj);
	{
		GeeSet* _tmp0_;
		GeeHashMap* _tmp1_;
		GeeMap* _tmp2_;
		self->priv->active_timers = (_tmp0_ = (GeeSet*) gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->active_timers), _tmp0_);
		self->priv->timers = (_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->timers), _tmp1_);
		self->priv->have_check_timers_timeout = FALSE;
		dvb_recordings_store_restore_from_dir (dvb_recordings_store_get_instance (), dvb_device_group_get_RecordingsDirectory (self->priv->_DeviceGroup));
		self->priv->recordings = (_tmp2_ = (GeeMap*) gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->recordings), _tmp2_);
		self->priv->check_timers_event_id = (guint) 0;
	}
	return obj;
}


void _dvb_recorder_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_recorder_introspect (DVBRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Recorder\">\n  <method name=\"AddTimer\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timer_id\" type=\"u\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerWithMargin\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timer_id\" type=\"u\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerForEPGEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timer_id\" type=\"u\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"DeleteTimer\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"SetStartTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetEndTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"end_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"SetDuration\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTitle\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"title\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllInformations\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"info\" type=\"(uubss)\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetActiveTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsTimerActive\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimer\">\n    <arg name=\"start_year\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimerForEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <signal name=\"RecordingStarted\">\n    <arg name=\"timer_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"RecordingFinished\">\n    <arg name=\"recording_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"Changed\">\n    <arg name=\"timer_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_recorder_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_recorder_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_recorder_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_recorder_dbus_register_object (connection, path, object);
}


static void dvb_recorder_class_init (DVBRecorderClass * klass) {
	dvb_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecorderPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_recorder_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_recorder_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_recorder_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recorder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_DEVICE_GROUP, g_param_spec_object ("DeviceGroup", "DeviceGroup", "DeviceGroup", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_COUNT, g_param_spec_uint ("count", "count", "count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_RECORDER_ELEMENT_TYPE, "element-type");
	g_type_set_qdata (DVB_TYPE_RECORDER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_recorder_dbus_vtable));
}


static void dvb_recorder_dvb_id_bus_recorder_interface_init (DVBIDBusRecorderIface * iface) {
	dvb_recorder_dvb_id_bus_recorder_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddTimer = dvb_recorder_real_AddTimer;
	iface->AddTimerWithMargin = dvb_recorder_real_AddTimerWithMargin;
	iface->AddTimerForEPGEvent = dvb_recorder_real_AddTimerForEPGEvent;
	iface->DeleteTimer = dvb_recorder_real_DeleteTimer;
	iface->GetTimers = dvb_recorder_real_GetTimers;
	iface->GetStartTime = dvb_recorder_real_GetStartTime;
	iface->SetStartTime = dvb_recorder_real_SetStartTime;
	iface->GetEndTime = dvb_recorder_real_GetEndTime;
	iface->GetDuration = dvb_recorder_real_GetDuration;
	iface->SetDuration = dvb_recorder_real_SetDuration;
	iface->GetChannelName = dvb_recorder_real_GetChannelName;
	iface->GetTitle = dvb_recorder_real_GetTitle;
	iface->GetAllInformations = dvb_recorder_real_GetAllInformations;
	iface->GetActiveTimers = dvb_recorder_real_GetActiveTimers;
	iface->IsTimerActive = dvb_recorder_real_IsTimerActive;
	iface->HasTimer = dvb_recorder_real_HasTimer;
	iface->HasTimerForEvent = dvb_recorder_real_HasTimerForEvent;
}


static void dvb_recorder_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_recorder_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = dvb_recorder_real_iterator;
	iface->get_element_type = dvb_recorder_real_get_element_type;
}


static void dvb_recorder_instance_init (DVBRecorder * self) {
	self->priv = DVB_RECORDER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_timers);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
}


static void dvb_recorder_finalize (GObject* obj) {
	DVBRecorder * self;
	self = DVB_RECORDER (obj);
	_g_object_unref0 (self->priv->active_timers);
	g_static_rec_mutex_free (&self->priv->__lock_timers);
	_g_object_unref0 (self->priv->timers);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	G_OBJECT_CLASS (dvb_recorder_parent_class)->finalize (obj);
}


GType dvb_recorder_get_type (void) {
	static volatile gsize dvb_recorder_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recorder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecorder), 0, (GInstanceInitFunc) dvb_recorder_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recorder_info = { (GInterfaceInitFunc) dvb_recorder_dvb_id_bus_recorder_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_recorder_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_recorder_type_id;
		dvb_recorder_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecorder", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recorder_type_id, DVB_TYPE_ID_BUS_RECORDER, &dvb_id_bus_recorder_info);
		g_type_add_interface_static (dvb_recorder_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_once_init_leave (&dvb_recorder_type_id__volatile, dvb_recorder_type_id);
	}
	return dvb_recorder_type_id__volatile;
}


static void dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = DVB_RECORDER (object);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		g_value_set_object (value, dvb_recorder_get_DeviceGroup (self));
		break;
		case DVB_RECORDER_COUNT:
		g_value_set_uint (value, dvb_recorder_get_count (self));
		break;
		case DVB_RECORDER_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = DVB_RECORDER (object);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		dvb_recorder_set_DeviceGroup (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




