/* -*- mode: C; c-basic-offset: 4; indent-tabs-mode: nil; -*- */
/* Copyright 2008 LiTL, LLC. All Rights Reserved. */

#ifndef __GIREPO_CLUTTER_CUSTOM_H__
#define __GIREPO_CLUTTER_CUSTOM_H__

#include <glib.h>
#include <clutter/clutter.h>
#ifdef HAVE_CLUTTER_GDKPIXBUF
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

G_BEGIN_DECLS

ClutterColor *   clutter_color_new               (void) G_GNUC_MALLOC;

void             clutter_color_set_components    (ClutterColor    *color,
                                                  GList           *components);
GList *          clutter_color_get_components    (ClutterColor    *color);

#ifdef HAVE_CLUTTER_GDKPIXBUF
gboolean         clutter_texture_set_from_pixbuf (ClutterTexture  *texture,
                                                  GdkPixbuf       *pixbuf);
#endif
ClutterGeometry *clutter_geometry_new            (void);
gint             clutter_geometry_get_x          (ClutterGeometry *geometry);
gint             clutter_geometry_get_y          (ClutterGeometry *geometry);
guint            clutter_geometry_get_width      (ClutterGeometry *geometry);
guint            clutter_geometry_get_height     (ClutterGeometry *geometry);
ClutterActorBox *clutter_actor_box_new           (void);
gint32           clutter_actor_box_get_x1        (ClutterActorBox *actor_box);
gint32           clutter_actor_box_get_y1        (ClutterActorBox *actor_box);
gint32           clutter_actor_box_get_x2        (ClutterActorBox *actor_box);
gint32           clutter_actor_box_get_y2        (ClutterActorBox *actor_box);
gint             clutter_units_to_device         (gint32           units);
gint32           clutter_device_to_units         (gint             device);
gint             clutter_event_get_x             (ClutterEvent    *event);
gint             clutter_event_get_y             (ClutterEvent    *event);
guint16          clutter_event_get_code          (ClutterEvent    *event);
guint            clutter_event_get_symbol        (ClutterEvent    *event);
guint32          clutter_event_get_unicode       (ClutterEvent    *event);
ClutterVertex*   clutter_vertex_new              (void) G_GNUC_MALLOC;
void             clutter_vertex_set_values       (ClutterVertex   *vertex,
                                                  int              x,
                                                  int              y,
                                                  int              z);

G_END_DECLS

#endif  /* __GIREPO_CLUTTER_CUSTOM_H__ */
