/*

                          Firewall Builder

                 Copyright (C) 2009 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: conntrackOptionsDialog.h 2502 2010-02-07 04:31:52Z vadim $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef __CONNTRACKOPTIONSDIALOG_H_
#define __CONNTRACKOPTIONSDIALOG_H_

#include <ui_conntrackoptionsdialog_q.h>
#include "DialogData.h"
#include <QDialog>

namespace libfwbuilder
{
    class FWObject;
};

class conntrackOptionsDialog : public QDialog
{
    Q_OBJECT

public:
    conntrackOptionsDialog(QWidget *parent, libfwbuilder::FWObject *o);
    ~conntrackOptionsDialog();

private:
    libfwbuilder::FWObject *obj;
    DialogData data;
    Ui::conntrackOptionsDialog_q *m_dialog;

    bool validate();

protected slots:
    virtual void accept();
    virtual void reject();
    virtual void toggleUseUnicast();
};

#endif // __CONNTRACKOPTIONSDIALOG_H_

