#include <set>
#include <strings.h>

using namespace std;

class CompressedTable
{
	struct ltstr
	{
		bool operator()(const char *s1, const char *s2) const
		{
			// Ignore upper/lower case.
			//
			return strcasecmp(s1, s2) < 0;
		}
	};

	set<const char *, ltstr> m_table;

public:
	CompressedTable();
	~CompressedTable();

	void Add(const char *name);
	void Add(char *exts, const char *delim);
	bool isForcedToCompress(const char *name) const;
};

