#include <cassert>
#include <cstring>
#include <cstdlib>
#include <rlog/rlog.h>
#include <stdlib.h>

#include "Lock.hpp"
#include "CompressedMagic.hpp"

void CompressedMagic::PopulateTable()
{
	m_table.insert("audio/mp4");
	m_table.insert("audio/mpeg");
	m_table.insert("audio/x-pn-realaudio");
	m_table.insert("audio/x-mod");
	m_table.insert("application/ogg");
	m_table.insert("application/pdf");
	m_table.insert("application/vnd.rn-realmedia");
	m_table.insert("application/x-arc");
	m_table.insert("application/x-arj");
	m_table.insert("application/x-bzip2");
	m_table.insert("application/x-compress");
	m_table.insert("application/x-cpio");
	m_table.insert("application/x-debian-package");
	m_table.insert("application/x-gzip");
	m_table.insert("application/x-lharc");
	m_table.insert("application/x-quicktime");
	m_table.insert("application/x-rar");
	m_table.insert("application/x-rpm");
	m_table.insert("application/x-shockwave-flash");
	m_table.insert("application/x-zip");
	m_table.insert("application/x-zoo");
	m_table.insert("image/gif");
	m_table.insert("image/jpeg");
	m_table.insert("image/jp2");
	m_table.insert("image/png");
	m_table.insert("image/x-quicktime");
	m_table.insert("video/3gpp");
	m_table.insert("video/mp4");
	m_table.insert("video/mp4v-es");
	m_table.insert("video/mpeg");
	m_table.insert("video/mp2t");
	m_table.insert("video/mpv");
	m_table.insert("video/quicktime");
}

CompressedMagic::CompressedMagic()
{
	m_magic = magic_open(MAGIC_MIME|MAGIC_PRESERVE_ATIME);
	if (!m_magic)
	{
		rError("CompressedMagic::CompressedMagic magic_open failed with: %s",
				magic_error(m_magic));
		abort();
	}
	magic_load(m_magic, NULL);

	PopulateTable();
}

CompressedMagic::~CompressedMagic()
{
	m_table.clear();

	magic_close(m_magic);
}

bool CompressedMagic::isNativelyCompressed(const char *buf, int len)
{
	const char *mime;

	Lock lock(m_Mutex);

	mime = magic_buffer(m_magic, buf, len);

	if (mime != NULL)
	{
		rDebug("Data identified as %s", mime);

		if (m_table.find(mime) != m_table.end())
		{
			return true;
		}
	}
	return false;
}

bool CompressedMagic::isNativelyCompressed(const char *name)
{
	const char *mime;

	Lock lock(m_Mutex);

	mime = magic_file(m_magic, name);

	if (mime != NULL)
	{
		rDebug("Data identified as %s", mime);

		if (m_table.find(mime) != m_table.end())
		{
			return true;
		}
	}
	return false;
}

