/* Copyright (C) 2000-2009 by George Williams */
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.

 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "gdraw.h"
#include "gicons.h"

static uint8 textmake_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x3, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut textmake_clut = { 4, 0, 0,
    { 0xffffff, 0x0, 0x444444, 0xff0000 } };

static struct _GImage textmake_base = {
    it_index,
    0,16,16,16,
    (uint8 *) textmake_data,
    &textmake_clut,
    0
};

static uint8 textc0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x4, 
	0x4, 0x4, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x4, 
	0x4, 0x4, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut textc0_clut = { 5, 0, 0,
    { 0xffffff, 0x0, 0x444444, 0xd0d0ff, 0x0000ff } };
    
static struct _GImage textc0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) textc0_data,
    &textc0_clut,
    0
};

static uint8 image0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x2, 
    0x2, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x7, 0x7, 0x5, 0x2, 
    0x2, 0x5, 0x5, 0x5, 0x5, 0x5, 0x6, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x7, 0x7, 0x5, 0x2, 
    0x2, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x2, 
    0x2, 0x5, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x4, 0x2, 
    0x2, 0x4, 0x1, 0x1, 0x1, 0x1, 0x4, 0x5, 
	0x4, 0x4, 0x4, 0x4, 0x5, 0x4, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 
	0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x4, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut image0_clut = { 8, 0, 0,
    { 0xffffff, 0x20a020, 0x0, 0x808080, 0x8000, 0xc0c0ff, 0xffffff, 0xffff00 } };

static struct _GImage image0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) image0_data,
    &image0_clut,
    0
};

static uint8 video0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
	0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
	0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x7, 
    0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x7, 0x7, 
    0x2, 0x2, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x2, 0x3, 0x2, 0x2, 0x2, 0x7, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x7, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x2, 0x7, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage video0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) video0_data,
    &image0_clut,
    0
};

static uint8 core0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage core0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) core0_data,
    &textmake_clut,
    0
};

static uint8 textplain0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textplain0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) textplain0_data,
    &textc0_clut,
    0
};

static uint8 dir0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage dir0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) dir0_data,
    &textc0_clut,
    0
};

static uint8 updir0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage updir0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) updir0_data,
    &textc0_clut,
    0
};

static uint8 object0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 
	0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
    0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage object0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) object0_data,
    &textmake_clut,
    0
};

static uint8 texthtml0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x0, 
	0x1, 0x3, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0
};

static struct _GImage texthtml0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) texthtml0_data,
    &textc0_clut,
    0
};

static uint8 textxml0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x0, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 0x1, 
	0x0, 0x3, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x0, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0
};

static struct _GImage textxml0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textxml0_data,
    &textc0_clut,
    0
};

static uint8 textcss0_data[] = {
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0
};

static struct _GImage textcss0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textcss0_data,
    &textc0_clut,
    0
};

static uint8 textjava0_data[] = {
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x3, 
    0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x3, 0x0, 0x0, 0x3, 
    0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x3, 0x0, 
    0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut textjava0_clut = { 6, 0, 0,
    { 0xffffff, 0xbbbbbb, 0x777777, 0x0, 0x444444, 0x8080ff } };

static struct _GImage textjava0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textjava0_data,
    &textjava0_clut,
    0
};

static uint8 textbdf0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textbdf0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textbdf0_data,
    &textc0_clut,
    0
};

static uint8 textfontps0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textfontps0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textfontps0_data,
    &textc0_clut,
    0
};

static uint8 textfontsfd0_data[] = {
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0
};

static struct _GImage textfontsfd0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textfontsfd0_data,
    &textc0_clut,
    0
};

static uint8 textps0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x4, 0x4, 0x0, 0x0, 0x0,
	0x4, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x4, 0x0, 0x4,
	0x0, 0x0, 0x4, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x4, 0x0, 0x4,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x4, 0x4, 0x0, 0x0, 0x0,
	0x4, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x4, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x4,
	0x4, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textps0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textps0_data,
    &textc0_clut,
    0
};

static uint8 unknown0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage unknown0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) unknown0_data,
    &textc0_clut,
    0
};

static uint8 audio0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage audio0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) audio0_data,
    &textc0_clut,
    0
};


static uint8 ttf0_data[] = {
    0x0, 0x1f, 
    0x7b, 0xdf, 
    0xfb, 0xff, 
    0xc0, 0x1, 
    0xdb, 0xfd, 
    0xd0, 0x85, 
    0xc2, 0xb1, 
    0xfa, 0xbf, 
    0xfa, 0xbf, 
    0xfa, 0xbf, 
    0xf0, 0xbf, 
    0xfe, 0xbf, 
    0xfc, 0x9f, 
    0xfd, 0xdf, 
    0xfc, 0x1f, 
    0xff, 0xff, 
};

static GClut ttf0_clut = { 2, 0, 1,
    { 0x0, 0xb0b0b0 } };

static struct _GImage ttf0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) ttf0_data,
    &ttf0_clut,
    1
};

static GClut macttf_clut = { 2, 0, 1,
    { 0xff, 0xffffff } };

static struct _GImage macttf0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) ttf0_data,
    &macttf_clut,
    1
};

static uint8 cid0_data[] = {
    0xff, 0xff, 
    0xfb, 0xff, 
    0x80, 0x3f, 
    0xbf, 0xbf, 
    0xff, 0xff, 
    0xc0, 0x7f, 
    0xfe, 0xff, 
    0xfd, 0xff, 
    0xfb, 0xff, 
    0x80, 0x3f, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xff, 0xff, 
};

static struct _GImage cid0_base = {
    it_mono,
    2071,11,16,2,
    (uint8 *) cid0_data,
    &ttf0_clut,
    1
};

static uint8 mac_data[] = {
    0xff, 0xff, 
    0xc0, 0x3, 
    0xdf, 0xfb, 
    0xd0, 0xb, 
    0xd7, 0xeb, 
    0xd5, 0xab, 
    0xd7, 0xeb, 
    0xd5, 0xab, 
    0xd6, 0x6b, 
    0xd7, 0xeb, 
    0xd0, 0xb, 
    0xdf, 0xfb, 
    0xdf, 0xb, 
    0xdf, 0xfb, 
    0xc0, 0x3, 
    0xff, 0xff, 
};

static struct _GImage mac_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) mac_data,
    &ttf0_clut,
    1
};

static uint8 tar0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x5, 0x5, 0x5, 0x5, 0x2, 0x2, 0x2, 
	0x4, 0x3, 0x4, 0x3, 0x3, 0x6, 0x4, 0x0, 
    0x1, 0x5, 0x5, 0x5, 0x2, 0x2, 0x2, 0x2, 
	0x4, 0x3, 0x4, 0x3, 0x6, 0x6, 0x4, 0x0, 
    0x1, 0x5, 0x5, 0x2, 0x2, 0x2, 0x2, 0x3, 
	0x3, 0x4, 0x3, 0x6, 0x6, 0x6, 0x4, 0x0, 
    0x1, 0x5, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 
	0x4, 0x3, 0x4, 0x6, 0x6, 0x6, 0x4, 0x0, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 
	0x4, 0x6, 0x4, 0x6, 0x6, 0x7, 0x4, 0x0, 
    0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x4, 0x6, 0x4, 0x6, 0x7, 0x7, 0x4, 0x0, 
    0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x6, 
	0x6, 0x4, 0x6, 0x7, 0x7, 0x7, 0x4, 0x0, 
    0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x6, 0x6, 
	0x4, 0x6, 0x4, 0x7, 0x7, 0x7, 0x4, 0x0, 
    0x1, 0x3, 0x3, 0x3, 0x3, 0x6, 0x6, 0x6, 
	0x4, 0x7, 0x4, 0x7, 0x7, 0x7, 0x4, 0x0, 
    0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut tar0_clut = { 16, 0, 0,
    { 0xffffff, 0xff0000, 0xa0a0ff, 0x8080ff, 0x0, 0xc0c0ff, 0x6060ff, 0x4040ff, 
    0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff } };

static struct _GImage tar0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) tar0_data,
    &tar0_clut,
    0x0
};

static uint8 compressed0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x0, 0x1, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x0, 0x0, 
    0x3, 0x5, 0x6, 0x6, 0x2, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x7, 0x4, 0x2, 0x0, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x8, 0x8, 0x8, 0x5, 0x5, 0x5, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x8, 0x8, 0x5, 0x5, 0x5, 0x6, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x8, 0x5, 0x5, 0x5, 0x6, 0x6, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x5, 0x5, 0x5, 0x6, 0x6, 0x6, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 
	0x6, 0x9, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 0x6, 
	0x9, 0x9, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x7, 0x4, 0x2, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x7, 0x1, 0x4, 0x1, 0x7, 0x1, 0x7, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x1, 0x7, 0x1, 0x4, 0x1, 0x7, 0x1, 0x0
};

static GClut compressed0_clut = { 16, 0, 0,
    { 0xffffff, 0x0, 0x3030, 0xff0000, 0xc0c0c0, 0xa0a0ff, 0x8080ff, 0x808080, 
    0xc0c0ff, 0x4040ff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff } };

static struct _GImage compressed0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) compressed0_data,
    &compressed0_clut,
    0x0
};

static uint8 homefolder_data[] = {
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1
};

static GClut homefolder_clut = { 3, 1, 0,
    0xb0b0b0, 0x000000, 0xd0d0ff };

static struct _GImage homefolder_base = {
    it_index,
    15420,20,16,20,
    (uint8 *) homefolder_data,
    &homefolder_clut,
    0
};

static uint8 configtool0_data[] = {
    0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x6, 0x7, 0x8, 0x9, 0xa, 
	0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd, 0xe, 0xf, 
	0x10, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x12, 0x13, 0x0, 0x0, 0x0, 0x14, 0x15, 0xf, 
	0x16, 0x17, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x19, 0x1a, 0x1b, 0x0, 0x1c, 0x1d, 0x1e, 0x1f, 
	0x20, 0x21, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x23, 0x24, 0x25, 0x26, 0x27, 0x20, 0x28, 0x29, 
	0x2a, 0x2b, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2d, 0x3, 0x2e, 0x2f, 0x30, 0x31, 0x31, 0xa, 
	0x27, 0x32, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x34, 0x35, 0x36, 0x37, 0x37, 0x37, 0x3, 0x38, 
	0x39, 0x3a, 0x3b, 0x3c, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 
	0x44, 0x45, 0x46, 0x47, 0x48, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 
	0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x57, 0x58, 
	0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 
	0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x69, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x7d, 0x7e, 0x7f, 0x80, 0x81
};

static GClut configtool0_clut = { 130, 1, 0,
    0xffffff, 0xc6c6d1, 0xdadae1, 0xdcdce3, 0xd4d4dc, 0xd9d9df, 0xd6d6dc, 0xd8d8e0, 
    0xfcfcfd, 0xfbfbfc, 0xe4e4ea, 0xceced7, 0xd2d2d9, 0xd5d5dd, 0xfdfdfd, 0xfefefe, 
    0xdadae2, 0xd4d4da, 0xb6b6c4, 0xd9d9de, 0xbebeca, 0xebebf0, 0xededf0, 0xccccd5, 
    0xe9e9eb, 0xadadbe, 0xbbbbc8, 0xdadade, 0xc7c7d0, 0xd7d7df, 0xf5f5f7, 0xf7f7f8, 
    0xececf0, 0xc7c7d1, 0xe6e6e8, 0xb1b1c1, 0xe0e0e6, 0xaeaebe, 0xb9b9c6, 0xcdcdd7, 
    0xeeeef2, 0xededf1, 0xdddde5, 0xbdbdca, 0xe7e7e9, 0xa7a7b8, 0xd9d9e0, 0xc8c8d3, 
    0xe3e3e9, 0xe5e5ea, 0xafafbe, 0xe0d6c9, 0xbbbbc6, 0xb2b2c1, 0xdbdbe3, 0xdddde4, 
    0xccccd7, 0xc0c0cd, 0xc1b0a1, 0xdbb059, 0xe4c8a0, 0xb2b2c0, 0x9e9eb2, 0xb9b9c7, 
    0xc1c1ce, 0xbebecb, 0xc3c3cf, 0xcbcbd5, 0xcdb89f, 0xd89d3a, 0xe79214, 0xe3aa30, 
    0xe0c18f, 0xc1c1cb, 0xa9a9b9, 0x9f9fb1, 0xa5a5b5, 0x9d9db0, 0xbeafa3, 0xd69d3c, 
    0xec9b17, 0xfc9c11, 0xf3a117, 0xe1a630, 0xdcc199, 0xe9e9ea, 0xe3e3e5, 0xd4cbc3, 
    0xc69953, 0xf0aa1d, 0xfdb11c, 0xffb21c, 0xfeb11c, 0xf6af1d, 0xdea836, 0xd8be99, 
    0xd6bd9f, 0xdca331, 0xfac028, 0xffc82a, 0xffc025, 0xffb71f, 0xfab01d, 0xdc9f2f, 
    0xd5ba95, 0xceb598, 0xd7a233, 0xfbd031, 0xffb61f, 0xffa112, 0xff9e10, 0xf9a417, 
    0xc68b35, 0xd29c36, 0xfaad1c, 0xffa011, 0xff960c, 0xfe9e10, 0xc68222, 0xcbb297, 
    0xcd8527, 0xf7a71a, 0xffa716, 0xfc9e11, 0xb9792a, 0xc6aa8f, 0xb0702c, 0xbb751f, 
    0xba7a2a, 0xa77031 };

static struct _GImage configtool0_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) configtool0_data,
    &configtool0_clut,
    0
};

static uint8 bookmark0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2, 0x3, 0x3, 0x1, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x4, 0x5, 0x5, 0x1, 0x1, 
	0x1, 0x5, 0x5, 0x5, 0x2, 0x3, 0x0, 0x0, 
    0x0, 0x2, 0x4, 0x5, 0x5, 0x5, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x2, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x6, 0x6, 0x3, 0x6, 0x6, 
	0x6, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x6, 0x6, 0x6, 0x6, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut bookmark0_clut = { 7, 1, 0,
    0xffffff, 0xba5f35, 0x999999, 0x8b4513, 0x4f4f4f, 0xe2e2e2, 0x0 };

static struct _GImage bookmark0_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) bookmark0_data,
    &bookmark0_clut,
    0
};

static uint8 nobookmark0_data[] = {
    0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 
    0x0, 0x6, 0x0, 0x2, 0x3, 0x3, 0x1, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x6, 0x0, 
    0x0, 0x0, 0x6, 0x4, 0x5, 0x5, 0x1, 0x1, 
	0x1, 0x5, 0x5, 0x5, 0x2, 0x6, 0x0, 0x0, 
    0x0, 0x2, 0x4, 0x6, 0x5, 0x5, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x2, 0x6, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x6, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x6, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x6, 0x3, 0x3, 
	0x3, 0x3, 0x6, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x6, 0x3, 
	0x3, 0x6, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x6, 0x6, 0x3, 0x6, 0x6, 
	0x6, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x6, 
	0x6, 0x3, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x6, 0x3, 
	0x3, 0x6, 0x3, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x6, 0x6, 0x6, 0x6, 
	0x3, 0x3, 0x6, 0x5, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x6, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x6, 0x5, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x6, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x6, 0x3, 0x0, 0x0, 
    0x0, 0x3, 0x6, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x5, 0x2, 0x6, 0x0, 0x0, 
    0x0, 0x6, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x6, 0x0, 
    0x6, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x6
};

static struct _GImage nobookmark0_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) nobookmark0_data,
    &bookmark0_clut,
    0
};



static uint8 back0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 
	0x5, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x6, 
	0x5, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x1, 0x4, 
	0x5, 0x7, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x4, 0x1, 0x4, 0x1, 
	0x4, 0x6, 0x4, 0x7, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x4, 0x1, 0x4, 0x1, 0x4, 
	0x6, 0x4, 0x6, 0x3, 0x7, 0x0, 0x0, 0x0, 
    0x1, 0x1, 0x4, 0x1, 0x4, 0x1, 0x4, 0x6, 
	0x4, 0x6, 0x4, 0x8, 0x8, 0x0, 0x0, 0x0, 
    0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 
	0x6, 0x1, 0x6, 0x8, 0x8, 0x0, 0x0, 0x0, 
    0x0, 0x5, 0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 
	0x9, 0x9, 0x9, 0x8, 0x7, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x5, 0x9, 0x5, 0x9, 0x5, 0x9, 
	0x5, 0x5, 0x5, 0x8, 0x7, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x5, 0x9, 0x5, 0x5, 0x5, 
	0x8, 0x8, 0x8, 0x8, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x2, 0x2, 0x5, 0x9, 0x5, 0x5, 
	0x7, 0x7, 0x7, 0x2, 0x2, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x7, 0x9, 0x5, 
	0x7, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x9, 
	0x7, 0x7, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 
	0x7, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0
};

static GClut back0_clut = { 10, 1, 0,
    0xffffff, 0x34fe9c, 0x848284, 0x48284, 0xcccefc, 0x48204, 0x4fe04, 0x4363c, 
    0x242224, 0x449aa4 };

static struct _GImage back0_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) back0_data,
    &back0_clut,
    0
};

static uint8 forward0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x5, 
	0x6, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x5, 
	0x8, 0x6, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x7, 0x5, 
	0x6, 0x3, 0x6, 0x3, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x7, 0x6, 0x8, 0x6, 
	0x3, 0x6, 0x3, 0x6, 0x3, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x7, 0x4, 0x8, 0x6, 0x8, 
	0x6, 0x3, 0x6, 0x3, 0x6, 0x3, 0x3, 0x0, 
    0x0, 0x0, 0x0, 0x9, 0x9, 0x6, 0x8, 0x6, 
	0x8, 0x6, 0x3, 0x6, 0x3, 0x6, 0x3, 0x3, 
    0x0, 0x0, 0x0, 0x9, 0x9, 0x8, 0x3, 0x8, 
	0x3, 0x8, 0x3, 0x3, 0x3, 0x3, 0x3, 0x8, 
    0x0, 0x0, 0x0, 0x7, 0x9, 0xa, 0xa, 0xa, 
	0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0x5, 0x0, 
    0x0, 0x0, 0x0, 0x7, 0x9, 0x5, 0x5, 0x5, 
	0xa, 0x5, 0xa, 0x5, 0xa, 0x5, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x9, 0x9, 0x9, 0x9, 
	0x5, 0x5, 0x5, 0xa, 0x5, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x7, 0x7, 0x7, 
	0x5, 0x5, 0xa, 0x5, 0x2, 0x2, 0x2, 0x0, 
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x7, 0x7, 
	0x5, 0xa, 0x7, 0x2, 0x2, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x7, 0x7, 
	0xa, 0x7, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x7, 
	0x7, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut forward0_clut = { 11, 1, 0,
    0xffffff, 0xffffff, 0x848284, 0x34fe9c, 0x48284, 0x48204, 0xcccefc, 0x4363c, 
    0x4fe04, 0x242224, 0x449aa4 };

static struct _GImage forward0_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) forward0_data,
    &forward0_clut,
    0x0
};




GImage _GIcon_compressed = { 0, { &compressed0_base } };
GImage _GIcon_tar = { 0, { &tar0_base } };
GImage _GIcon_ttf = { 0, { &ttf0_base } };
GImage _GIcon_unknown = { 0, { &unknown0_base } };
GImage _GIcon_texthtml = { 0, { &texthtml0_base } };
GImage _GIcon_textxml = { 0, { &textxml0_base } };
GImage _GIcon_textcss = { 0, { &textcss0_base } };
GImage _GIcon_textjava = { 0, { &textjava0_base } };
GImage _GIcon_textfontsfd = { 0, { &textfontsfd0_base } };
GImage _GIcon_textfontbdf = { 0, { &textbdf0_base } };
GImage _GIcon_textfontps = { 0, { &textfontps0_base } };
GImage _GIcon_textps = { 0, { &textps0_base } };
GImage _GIcon_textplain = { 0, { &textplain0_base } };
GImage _GIcon_textc = { 0, { &textc0_base } };
GImage _GIcon_textmake = { 0, { &textmake_base } };
GImage _GIcon_object = { 0, { &object0_base } };
GImage _GIcon_updir = { 0, { &updir0_base } };
GImage _GIcon_dir = { 0, { &dir0_base } };
GImage _GIcon_core = { 0, { &core0_base } };
GImage _GIcon_image = { 0, { &image0_base } };
GImage _GIcon_video = { 0, { &video0_base } };
GImage _GIcon_audio = { 0, { &audio0_base } };
GImage _GIcon_cid = { 0, { &cid0_base } };
GImage _GIcon_mac = { 0, { &mac_base } };
GImage _GIcon_macttf = { 0, { &macttf0_base } };

GImage _GIcon_homefolder = { 0, &homefolder_base };
GImage _GIcon_configtool = { 0, &configtool0_base };
GImage _GIcon_bookmark   = { 0, &bookmark0_base };
GImage _GIcon_nobookmark = { 0, &nobookmark0_base };

GImage _GIcon_backarrow = { 0, &back0_base };
GImage _GIcon_forwardarrow = { 0, &forward0_base };
