/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef TYPES_H
#define TYPES_H

#include <qcheckbox.h>
#include <qlistview.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <qvaluevector.h>

#include <klocale.h>

#include "playlist.h"

enum ItemWithAccel
{
	TRAY_PLAY = 0,
	TRAY_STOP,
	TRAY_LEFT,
	TRAY_RIGHT,
	TRAY_QUIT,
	WND_NEWPLAYLIST,
	WND_UP,
	WND_DOWN,
	WND_REMOVE,
	WND_CURRENT,
	CONTEXT_ADDFILES,
	CONTEXT_ADDFOLDER,
	CONTEXT_ADDCD,
	CONTEXT_LASTFM,
	CONTEXT_EQUALIZER,
	CONTEXT_SOUND,
	CONTEXT_RELOADMETA,
	CONTEXT_ACCELS,
	CONTEXT_SAVE,
	CONTEXT_RMBOTH,
	CONTEXT_SHUFFLE,
	CONTEXT_TAGS,
	CONTEXT_LYRICS,
	CONTEXT_DUPLICATE,
	CONTEXT_REMOVABLE,
	ACTION_SELECTALL,
	ACTION_COPYONDEST,
	ACTION_SENDONDEST,
	ACTION_VOLHIGHER,
	ACTION_VOLLOWER,
	ACTION_PREVCURRENT,
	ACTION_NEXTCURRENT,
	ACTION_POPUPCOPYONDEST,
	ACTION_POPUPSENDONDEST,
	ACTION_POPUPAPPENDTO,
	ACTION_QUIT
};

struct lfmItem
{
	lfmItem() {};
	lfmItem(const QString & art, const QString & tit, const QString & alb, const QString & len,
		 const QString & dat) : artist(art), title(tit), album(alb), length(len), date(dat) {};

	QString artist;
	QString title;
	QString album;
	QString length;
	QString date;
};

class eqProfile
{
	public:
		eqProfile() { name = i18n("Unnamed"); amp = 100; for (int i = 0 ; i != 10 ; i++) freq[i] = 0; }
		eqProfile(const QString & s)
		{
			if (s.find(";") == -1)
			{
				name = s;
				amp = 100;
			
				for (int i = 0 ; i != 10 ; i++)
					freq[i] = 0;
			}
			else
			{
				int j = 0;
				QStringList l = QStringList::split(";", s);
				QStringList::const_iterator i = l.begin();

				name = (*(i++));
				amp = (*(i++)).toInt();

				for ( ; i != l.end() ; i++, j++)
					freq[j] = (*i).toInt();
			}
		}

		QString getProfileAsString() const
		{
			QString s = (getName() + ";" + QString::number(getAmp()));

			for (int i = 0 ; i != 10 ; i++)
				s += (";" + QString::number(getFreq(i)));

			return s;
		}

		QString getName() const { return name; }
		int getAmp() const { return amp; }
		int getFreq(const int & i) const { if ((i >= 0) && (i < 10)) return freq[i]; else return 0; }

		void setName(const QString & _name) { name = _name; }
		void setAmpFreq(const int & _amp, const int * _freq)
			{ amp = _amp; for (int i = 0 ; i != 10 ; i++) freq[i] = _freq[i]; }

	private:
		QString name;
		int amp;
		int freq[10];
};

class objWithPos
{
	public:
		objWithPos() { obj = 0; x = 0; y = 0; }
		objWithPos(QObject * _obj, const int & _x, const int & _y) { obj = _obj; x = _x; y = _y; };
		
		QObject * getObject() { return obj; }
		int getX() { return x; }
		int getY() { return y; }

	private:
		QObject * obj;
		int x;
		int y;
};

typedef QValueList<lfmItem> lfmItemList;
typedef QValueList<QCheckBox *> chks;
typedef QValueList<int> ints;
typedef QValueList<eqProfile> eqProfiles;
typedef QValueList<objWithPos> objsWithPos;
typedef QPtrList<QListViewItem> QListViewItems;
typedef QPtrListIterator<QListViewItem> QListViewItemsIterator;

#endif
