/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "qmmainwindow.h"

#include <qcursor.h>

QMMainWindow::QMMainWindow(QWidget * parent, const char * name) : QMainWindow(parent, name)
{
}

QMMainWindow::~QMMainWindow()
{
}

void QMMainWindow::mouseDoubleClickEvent(QMouseEvent * e)
{
	switch (e->button())
	{
		case Qt::LeftButton:
			emit doubleClicked();
		break;
		case Qt::RightButton:
		break;
		default:
		break;
	}

	QMainWindow::mouseDoubleClickEvent(e);
}

void QMMainWindow::mousePressEvent(QMouseEvent * e)
{
	switch (e->button())
	{
		case Qt::LeftButton:
			emit clicked();
		break;
		case Qt::RightButton:
			emit rightMouseButtonClicked(QCursor::pos());
		break;
		default:
		break;
	}

	QMainWindow::mousePressEvent(e);
}

void QMMainWindow::mouseReleaseEvent(QMouseEvent * e)
{
	QMainWindow::mouseReleaseEvent(e);
}

void QMMainWindow::mouseMoveEvent(QMouseEvent * e)
{
	QMainWindow::mouseMoveEvent(e);
}

void QMMainWindow::keyPressEvent(QKeyEvent * e)
{
	emit keyPressed(e);

	QMainWindow::keyPressEvent(e);
}
