/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef LYRICS_H
#define LYRICS_H

#include <qbuffer.h>
#include <qstring.h>

class Lyrics
{
	public:
		Lyrics();
		~Lyrics();

		void setTitle(const QString & t);
		void setArtist(const QString & a);

		void setPath(const QString & p);
		
		QString getFromLocal();
		QString getFromBuffer(QBuffer * buffer);
		
	private:
		QString title;
		QString artist;
		QString lyrics;
		QString path;

		void makeLyricsDir() const;
		void saveAsLocal() const;
};

#endif
