/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "kmsystemtray.h"

KMSystemTray::KMSystemTray(QWidget * parent, const char * name) : KSystemTray(parent, name)
{
	menu = new KPopupMenu(this);
}

KMSystemTray::~KMSystemTray()
{
}

KPopupMenu * KMSystemTray::contextMenu() const
{
	return menu;
}

void KMSystemTray::mousePressEvent(QMouseEvent * e)
{
	switch (e->button())
	{
		case LeftButton:
			toggleActive();
		break;
		case RightButton:
			menu->popup(e->globalPos());
		break;
		case MidButton:
		break;
		default:
		break;
	}
}

void KMSystemTray::wheelEvent(QWheelEvent * e)
{
	emit wheelMoved(e);
}
