/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "accelviewitem.h"

AccelViewItem::AccelViewItem(KListView * parent, const QString & text, const QKeySequence & seq)
	: KListViewItem(parent, text, seq)
{
	setAccel(seq);
}

void AccelViewItem::setAccel(const QKeySequence & a)
{
	ks = a;

	setText(1, ks);
}

const QKeySequence & AccelViewItem::accel() const
{
	return ks;
}
