/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimadsp.h 839 2009-03-27 07:13:33Z tsuruda $
 */

#ifndef __DKIM_ADSP_H__
#define __DKIM_ADSP_H__

#include <stdbool.h>
#include "dnsresolv.h"
#include "dkim.h"

typedef struct DkimAdsp DkimAdsp;

extern DkimAdsp *DkimAdsp_build(const DkimPolicy *policy, const char *keyval, dkim_stat_t *dstat);
extern DkimAdsp *DkimAdsp_retrieve(const DkimPolicy *policy, const char *policydomain,
                                   DnsResolver *resolver, dkim_stat_t *dstat);
extern void DkimAdsp_free(DkimAdsp *self);
extern dkim_adsp_signpractice_t DkimAdsp_getSigningPractice(const DkimAdsp *self);

#endif /* __DKIM_ADSP_H__ */
