/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef CONVERTTHREAD_H
#define CONVERTTHREAD_H

#include <QProcess>
#include <QThread>
#include <QTimer>

class ConvertThread : public QThread
{
    Q_OBJECT

    public:
        ConvertThread(QObject* parent, const QStringList &filenames, const QString& format);
        void run();

    private slots:
        void processFinished(int);
        void processError(QProcess::ProcessError);
        void updateProgress();
        void cancelProcess();

    signals:
        void totalFrames(int);
        void currentFrame(int);
        void currentFile(QString);
        void beginBurning();

    private:
        QStringList m_filenames;
        QString m_format;

        QProcess m_process;

        QTimer m_timer;

        int m_cNumber;

        bool m_foundTotalFrames;
        bool m_hadError;
        bool m_wasCanceled;
};

#endif // CONVERTTHREAD_H
