/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef BURNIMAGETHREAD_H
#define BURNIMAGETHREAD_H

#include <QProcess>
#include <QThread>
#include <QTimer>

class BurnImageThread : public QThread
{
    Q_OBJECT

    public:
        BurnImageThread(QObject* parent, const QString& device, const QString &filename);
        void run();

    private slots:
        void processFinished(int);
        void processError(QProcess::ProcessError);
        void updateProgress();
        void cancelProcess();

    signals:
        void imageSize(int);
        void progress(int);

    private:
        QString m_device;
        QString m_filename;

        QProcess m_process;

        QTimer m_timer;

        bool m_hadError;
        bool m_wasCanceled;
};

#endif // BURNIMAGETHREAD_H
