/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QtTest/QtTest>

#include <Decibel/DBusNames>

#include "componentmanager.h"
#include "componentmanagertest.h"

namespace
{
    const QString application_name_postfix("_TESTSUITE");
}

void ComponentManagerTest::init()
{
    QCoreApplication::instance()->setOrganizationName(Decibel::organisation_name);
    QCoreApplication::instance()->setApplicationName(Decibel::system_name +
                                                     application_name_postfix);
}

void ComponentManagerTest::cleanup()
{
}

// ---------------------- Helper methods ---------------------- //

QTEST_MAIN(ComponentManagerTest)
#include "componentmanagertest.moc"
