#ifndef __DBUS_PROXY_DBUS_EXAMPLE_COMPUTER_H
#define __DBUS_PROXY_DBUS_EXAMPLE_COMPUTER_H

#include <dbus-cxx.h>

#include "computer.h"

#include "calculator_proxy.h"

#ifndef __DBUS_EXAMPLES__COMPUTER__OPERATION_ITERATOR_SUPPORT
  #define __DBUS_EXAMPLES__COMPUTER__OPERATION_ITERATOR_SUPPORT
  DBUS_CXX_ITERATOR_SUPPORT( Examples::Computer::Operation , uint32_t )
#endif


namespace DBus {
  namespace Example {

    class ComputerProxy : public CalculatorProxy
    {
      protected:
        ComputerProxy( ::DBus::Connection::pointer conn, const std::string& dest="dbuscxx.example.computer.server", const std::string& path="/dbuscxx/example/Computer"):
          CalculatorProxy(conn, dest, path)
        {
          ::DBus::Path child_path;

          m_method_compute_tuy = this->create_method< uint64_t,Examples::Computer::Operation,uint8_t >( "Computer.Basic", "compute" );
          m_method_factorial_ty = this->create_method< uint64_t,uint8_t >( "Computer.Basic", "factorial" );
          m_method_fibonacci_ty = this->create_method< uint64_t,uint8_t >( "Computer.Basic", "fibonacci" );
          m_method_thue_morse_ty = this->create_method< uint64_t,uint8_t >( "Computer.Basic", "thue_morse" );
          m_method_last_op_u = this->create_method< Examples::Computer::Operation >( "Computer.Basic", "last_op" );
          m_signal_computation = this->create_signal<void,std::string,uint64_t,uint8_t>( "Computer.Basic", "computation" );
          m_signal_operation = this->create_signal<void,Examples::Computer::Operation>( "Computer.Basic", "operation" );
        }

      public:

        typedef DBusCxxPointer<ComputerProxy> pointer;

        static pointer create( ::DBus::Connection::pointer conn,
                               const std::string& dest="dbuscxx.example.computer.server",
                               const std::string& path="/dbuscxx/example/Computer"
                             )
        { return pointer( new ComputerProxy(conn, dest, path)); }


        uint64_t compute( Examples::Computer::Operation op, uint8_t n ) { return (*m_method_compute_tuy)( op, n); }

        uint64_t factorial( uint8_t n ) { return (*m_method_factorial_ty)( n); }

        uint64_t fibonacci( uint8_t n ) { return (*m_method_fibonacci_ty)( n); }

        uint64_t thue_morse( uint8_t n ) { return (*m_method_thue_morse_ty)( n); }

        Examples::Computer::Operation last_op( ) { return (*m_method_last_op_u)(); }

        ::DBus::signal_proxy<void,std::string,uint64_t,uint8_t >& signal_computation() { return *m_signal_computation; }

        ::DBus::signal_proxy<void,Examples::Computer::Operation >& signal_operation() { return *m_signal_operation; }


      protected:


        ::DBus::MethodProxy<uint64_t,Examples::Computer::Operation,uint8_t>::pointer m_method_compute_tuy;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_factorial_ty;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_fibonacci_ty;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_thue_morse_ty;
        ::DBus::MethodProxy<Examples::Computer::Operation>::pointer m_method_last_op_u;
        ::DBus::signal_proxy<void,std::string,uint64_t,uint8_t>::pointer m_signal_computation;
        ::DBus::signal_proxy<void,Examples::Computer::Operation>::pointer m_signal_operation;


    };

  }
}

#endif
