#ifndef __DBUS_ADAPTER_DBUS_EXAMPLE_CALCULATOR_H
#define __DBUS_ADAPTER_DBUS_EXAMPLE_CALCULATOR_H

#include <dbus-cxx.h>

#include "calculator.h"


namespace DBus {
  namespace Example {

    class CalculatorAdapter : public ::DBus::Object
    {
      protected:
        CalculatorAdapter( Examples::Calculator* adaptee=NULL, const std::string& path="/dbuscxx/example/Calculator"):
          ::DBus::Object(path),
          m_adaptee(adaptee)
        {

          ::DBus::MethodBase::pointer temp_method;

          temp_method = this->create_method<double,double,double>( "Calculator.Basic", "add", sigc::mem_fun(*this, &CalculatorAdapter::add_adapter_stub_ddd) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "a" );
          temp_method->set_arg_name( 2, "b" );
          temp_method = this->create_method<double,double,double>( "Calculator.Basic", "sub", sigc::mem_fun(*this, &CalculatorAdapter::sub_adapter_stub_ddd) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "a" );
          temp_method->set_arg_name( 2, "b" );
          temp_method = this->create_method<double,double,double>( "Calculator.Basic", "mul", sigc::mem_fun(*this, &CalculatorAdapter::mul_adapter_stub_ddd) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "a" );
          temp_method->set_arg_name( 2, "b" );
          temp_method = this->create_method<double,double,double>( "Calculator.Basic", "div", sigc::mem_fun(*this, &CalculatorAdapter::div_adapter_stub_ddd) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "a" );
          temp_method->set_arg_name( 2, "b" );
          temp_method = this->create_method<double>( "Calculator.Basic", "pi", sigc::mem_fun(*this, &CalculatorAdapter::pi_adapter_stub_d) );
          temp_method->set_arg_name( 0, "result" );
          temp_method = this->create_method<void>( "Calculator.Basic", "print_pi", sigc::mem_fun(*this, &CalculatorAdapter::print_pi_adapter_stub_v) );
          m_signal_adapter_calculation = this->create_signal<void,std::string,std::string,double,double,double>("Calculator.Basic","calculation");
          m_signal_adapter_calculation->set_arg_name( 0, "op" );
          m_signal_adapter_calculation->set_arg_name( 1, "opsym" );
          m_signal_adapter_calculation->set_arg_name( 2, "result" );
          m_signal_adapter_calculation->set_arg_name( 3, "a" );
          m_signal_adapter_calculation->set_arg_name( 4, "b" );
          if ( m_adaptee ) m_signal_adapter_connection_calculation = m_adaptee->signal_calculation().connect( *m_signal_adapter_calculation );
        }

      public:

        typedef DBusCxxPointer<CalculatorAdapter> pointer;

        static pointer create( Examples::Calculator* adaptee=NULL, const std::string& path="/dbuscxx/example/Calculator")
          { return pointer( new CalculatorAdapter(adaptee, path)); }

        Examples::Calculator* adaptee() { return m_adaptee; }

        void set_adaptee( Examples::Calculator* adaptee ) {
          m_adaptee = adaptee;
          m_signal_adapter_connection_calculation.disconnect();
          if ( m_adaptee ) m_signal_adapter_connection_calculation = m_adaptee->signal_calculation().connect( *m_signal_adapter_calculation );
        }

        void set_adaptee( Examples::Calculator& adaptee ) {
          this->set_adaptee(&adaptee);
        }


      private:

        Examples::Calculator* m_adaptee;


        void check_adaptee() { if ( not m_adaptee) throw ::DBus::ErrorInvalidAdaptee::create(); }

        double add_adapter_stub_ddd( double a, double b ) { this->check_adaptee(); return m_adaptee->add( a, b); }
        double sub_adapter_stub_ddd( double a, double b ) { this->check_adaptee(); return m_adaptee->subtract( a, b); }
        double mul_adapter_stub_ddd( double a, double b ) { this->check_adaptee(); return m_adaptee->multiply( a, b); }
        double div_adapter_stub_ddd( double a, double b ) { this->check_adaptee(); return m_adaptee->divide( a, b); }
        double pi_adapter_stub_d( ) { this->check_adaptee(); return m_adaptee->pi(); }
        void print_pi_adapter_stub_v( ) { this->check_adaptee(); m_adaptee->print_pi(); }
        ::DBus::signal<void,std::string,std::string,double,double,double>::pointer m_signal_adapter_calculation;
        sigc::connection m_signal_adapter_connection_calculation;


    };

  }
}

#endif
