/**
 *
 * Beryl useless transparent terminals eyecandy plugin plugin
 *
 * fakeargb.c
 *
 * Copyright (c) 2006 Robert Carr <racarr@beryl-project.org>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

#include "fakeargb.h"

COMPIZ_PLUGIN_20090315 (fakeargb, FakePluginVTable);

void
FakeWindow::toggle ()
{
    FAKE_SCREEN (screen);

    if (fs->black)
	isFaked = !isFaked;
    if (isFaked)
    {
	fs->handle = 0;
	fs->black = !fs->black;
	gWindow->glDrawTextureSetEnabled (this, true);
    }
    else
    {
	gWindow->glDrawTextureSetEnabled (this, false);
    }

    cWindow->addDamage ();
}

bool
FakeScreen::toggle (CompAction         *action,
		    CompAction::State  state,
		    CompOption::Vector options)
{
    CompWindow *w = screen->findWindow (CompOption::getIntOptionNamed (options,
							"window", 0));

    if (w)
	FakeWindow::get (w)->toggle ();

    return true;
}

GLFragment::FunctionId
FakeScreen::getFakeFragmentFunction (GLTexture *texture)
{
    GLFragment::FunctionData *data;
    int              target;

    if (texture->target () == GL_TEXTURE_2D)
	target = COMP_FETCH_TARGET_2D;
    else
	target = COMP_FETCH_TARGET_RECT;

    if (handle)
	return handle;

    data = new GLFragment::FunctionData ();
    if (data)
    {
	data->addTempHeaderOp ("neg");
	data->addTempHeaderOp("temp");

	data->addFetchOp ("output", NULL, target);
	data->addDataOp ("RCP neg.a, output.a;");
 		
	data->addDataOp ("MUL output.rgb, output.a, output;");
	 		
	data->addDataOp("MOV temp, output;");
		
	if (!black)
    	    data->addDataOp("SUB temp.rgb, 1.0, temp;");
		
	data->addDataOp("ADD output.a, 0, temp.r;");
	data->addDataOp("ADD output.a, output.a, temp.g;");
	data->addDataOp("ADD output.a, output.a, temp.b;");
	data->addDataOp("MUL output.a, output.a, 0.33;");
	data->addDataOp ("MUL output.rgb, output.a, output;");

	data->addColorOp ("output", "output");

	if (!data->status ())
	{
	    delete data ;
	    return 0;
	}

	handle = data->createFragmentFunction ("fake");

	delete data;

	return handle;
    }

    return 0;
}

void
FakeWindow::glDrawTexture (GLTexture *texture,
			   GLFragment::Attrib &attrib,
			   unsigned int mask)
{
    FAKE_SCREEN (screen);

    bool doFake = false;

    foreach (GLTexture *tex, gWindow->textures ())
    {
	if (tex->name () == texture->name ())
	{
	    doFake = true;
	    break;
	}
    }
	
    if (isFaked && (doFake) &&
	GL::fragmentProgram)
    {
	GLFragment::Attrib      fa = attrib;
	GLFragment::FunctionId  function;

	function = fs->getFakeFragmentFunction (texture);
	if (function)
	    fa.addFunction (function);

	gWindow->glDrawTexture (texture, fa, mask);
    }
    else
    {
	gWindow->glDrawTexture (texture, attrib, mask);
    }
}

FakeScreen::FakeScreen (CompScreen *screen) :
    PluginClassHandler <FakeScreen, CompScreen> (screen),
    cScreen (CompositeScreen::get (screen)), 
    gScreen (GLScreen::get (screen)),
    handle (0),
    black (true)
{
    optionSetWindowToggleKeyInitiate (boost::bind (&FakeScreen::toggle, this,
						   _1, _2, _3));
    optionSetWindowToggleButtonInitiate (boost::bind (&FakeScreen::toggle, this,
						      _1, _2, _3));
}

FakeScreen::~FakeScreen ()
{
    if (handle)
	GLFragment::destroyFragmentFunction (handle);
}

FakeWindow::FakeWindow (CompWindow *window) :
    PluginClassHandler <FakeWindow, CompWindow> (window),
    cWindow (CompositeWindow::get (window)),
    gWindow (GLWindow::get (window)),
    isFaked (false)
{
    GLWindowInterface::setHandler (gWindow, false);
}

bool
FakePluginVTable::init ()
{
    if (!CompPlugin::checkPluginABI ("core", CORE_ABIVERSION))
	return false;
    if (!CompPlugin::checkPluginABI ("composite", COMPIZ_COMPOSITE_ABI))
	return false;
    if (!CompPlugin::checkPluginABI ("opengl", COMPIZ_OPENGL_ABI))
	return false;

    return true;
}
