;;; egg-cursor.el --  Specify current input mode: In egg or out of egg.

;; Author: Masatake YAMATO <scs30154@bkc.ritsumei.ac.jp>
;;         Kazutaka SHIGENO <shigeno@vacation.kyushu-id.ac.jp>
;;         Hiroshi YOKOTA <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi YOKOTA <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 1.1
;; Keywords: egg wnn color color-mate kanakan-cursor
;; Content-Type: text/plain; charset=x-euc-jp

;; This code is derived from skk-cursor.el.

;;; This program is distributed under the GNU GENERAL PUBLIC LICENSE.

;;; History:
;; egg-cursor.el for Color-Mate Ver.1.1:
;;    o XEmacs fix.
;; egg-cursor.el for Color-Mate Ver.1.0.1:
;;    o Small change for leim conflict detect.
;; egg-cursor.el for Color-Mate Ver.1.0:
;;    o Port to Color-Mate.
;;
;; 6th: Wed Dec 13 17:48:44 JST 1995
;;    o Add new advices. Thanx to Mukunoki Masayuki<mukunoki@kuis.kyoto-u.ac.jp>.
;; 5th: Mon Dec 11 19:55:22 JST 1995
;;    o post-command-hook is never used !
;; 4th: Fri Nov 24 01:10:41 1995
;;    o Evade the color map exhausting error.(By scs30154)
;; 3rd: Fri Nov  3 19:53:36 1995
;;    o scs30154 puts make-variable-buffer-local out of the function.
;; 2nd: Fri Nov  3 16:58:21 1995
;; 1st: Tue Oct 24 11:42:11 1995

;;;; Usage
;;; Put this file in emacs-lisp directory.
;;; And put (require 'egg-cursor) in your .emacs.
;;;  From edtion 4th, when the color map exhausting error occurs, The cursor 
;;; color is set egg-mode-off-cursor-color. And if the variable, 
;;; cursor-color-error-report-always is t, the error message is displayed on the
;;; mini-buffer always. This means: 
;;; 
;;;  1) Don't setq egg-mode-off-cursor-colors in mule session.(?)
;;;

;;;; Note
;;; This code will work with mule2.x / {X,GNU}Emacs 20 running on window system.
;;; If you want to change the color for each input mode into "yellow",
;;; put (setq egg-mode-on-cursor-color "yellow") in your .emacs.

;---------------------------------------------------------------;
;                 egg-cursor.el for Color-Mate
;---------------------------------------------------------------;
;$Id: egg-cursor.el,v 1.2 2002/05/11 02:32:22 elca Exp $

;;;; Code

(require 'egg)

;; Entry point, key
(global-set-key "\C-\\" 'toggle-egg-mode-with-cursor-color)

;; Color Setup
(defvar egg-mode-on-cursor-color "forestgreen"
  "Cursor color for egg mode")
(defvar egg-mode-off-cursor-color nil
  "Cursor color for mode out of egg")

(defvar egg-cursor-color-bound-to-each-buffer nil
  "This variable will be referred when buffer is selected.
This is egg-cursor's buffer-local variable. Don't use it!")
(make-variable-buffer-local 'egg-cursor-color-bound-to-each-buffer) ;;3rd edition


;; ̵꤬ϽΥ뿧Ѥ
(if (not egg-mode-off-cursor-color)
    (setq egg-mode-off-cursor-color
	  (if (featurep 'xemacs)
	      (face-background-name 'text-cursor)
	    (cdr (assoc 'cursor-color (frame-parameters (selected-frame)))))
	  ))

;;
;; ¾ kanakan-cursor ץȤϢѤѿ
;;
(defvar canna-cursor-japanese-mode "init" "If \"on\", you are input words with canna.")
(defvar egg-cursor-japanese-mode "init" "If \"on\", you are input words with egg.")
(defvar skk-cursor-japanese-mode "init" "If \"on\", you are input words with skk.")
(defvar sj3-cursor-japanese-mode "init" "If \"on\", you are input words with sj3.")
(make-variable-buffer-local 'canna-cursor-japanese-mode)
(make-variable-buffer-local 'egg-cursor-japanese-mode)
(make-variable-buffer-local 'skk-cursor-japanese-mode)
(make-variable-buffer-local 'sj3-cursor-japanese-mode)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; "C-\\" 򲡤˸ƤФ롣
;;
(defun toggle-egg-mode-with-cursor-color ()
  "Wrapper function of toggle-egg-mode for cursor color management."
  (interactive)
  (toggle-egg-mode)
  (if (and egg:*mode-on* egg:*input-mode*)
      (progn
	(setq egg-cursor-color-bound-to-each-buffer
	      egg-mode-on-cursor-color)
	(setq egg-cursor-japanese-mode "on"))
    (progn
      (setq egg-cursor-color-bound-to-each-buffer
	    egg-mode-off-cursor-color)
      (setq egg-cursor-japanese-mode "off"))
    )
  (egg-cursor-set egg-cursor-japanese-mode)
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; re-define egg:select-window-hook
;;
; select-window-hook եå
; ¾ kanakan-cursor ⥸塼Ȥζͤƣʹˤ
(setq select-window-hook
      '(lambda (old new)
	 (run-hook-with-args 'kanakan-cursor-select-window-hooks old new)))
(add-hook 'kanakan-cursor-select-window-hooks 'egg:select-window-hook)

(defun egg:select-window-hook (old new)
  (if (and (eq old (minibuffer-window))
	   (not (eq new (minibuffer-window))))
      (save-excursion
	(set-buffer (window-buffer (minibuffer-window)))
	(setq minibuffer-preprompt nil
	      egg:*mode-on* (default-value 'egg:*mode-on*)
	      egg:*input-mode* (default-value 'egg:*input-mode*)
	      egg:*in-fence-mode* (default-value 'egg:*in-fence-mode*))))
  (if (eq new (minibuffer-window))
      (setq minibuffer-window-selected t)
	  (setq minibuffer-window-selected nil))
  (save-excursion
    (set-buffer (window-buffer new))
    (egg-cursor-set egg-cursor-japanese-mode)))

;; add hook
(defadvice bury-buffer (after add-egg-cursor-set first activate)
  (egg-cursor-set egg-cursor-japanese-mode))
(defadvice kill-buffer (after add-egg-cursor-set first activate)
  (egg-cursor-set egg-cursor-japanese-mode))
(defadvice switch-to-buffer (after add-egg-cursor-set first activate)
  (egg-cursor-set egg-cursor-japanese-mode))

;; add hook
(add-hook 'after-make-frame-hook
	  (function
	   (lambda ()
	     (egg-cursor-set egg-cursor-japanese-mode))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 뿧
;; set cursor color
;;
;; canna, egg, skk, sj3 Τɤ줫Ĥδϥ⡼ɤ on ˤʤäƤ
;; 뿧򸵤᤹ʤʤ褦ˤƤ롣
;;
(defun egg-cursor-set (mode)
  "Cursor color changer with conflict management."
  (progn
    (cond
     ((equal mode "on")
      (set-cursor-color egg-cursor-color-bound-to-each-buffer))
     ((equal mode "off")
      (if (not (or (equal canna-cursor-japanese-mode "on")
		   (equal skk-cursor-japanese-mode "on")
		   (equal sj3-cursor-japanese-mode "on")))
	  (set-cursor-color egg-cursor-color-bound-to-each-buffer)))
     ((equal mode "init")
      (if (not (or (equal canna-cursor-japanese-mode "on")
		   (equal skk-cursor-japanese-mode "on")
		   (equal sj3-cursor-japanese-mode "on")))
	  (set-cursor-color egg-mode-off-cursor-color)))
     )))


(provide 'egg-cursor)

;;; egg-cursor.el ends here
