/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.util;

import java.util.Hashtable;
import org.exolab.adaptx.net.URIException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.URIResolver;
import org.exolab.adaptx.util.ErrorObserverAdapter;
import org.exolab.adaptx.util.QuickStack;
import org.exolab.adaptx.xml.AttributeListWrapper;
import org.exolab.adaptx.xml.XMLUtil;
import org.exolab.adaptx.xslt.AttributeSet;
import org.exolab.adaptx.xslt.CopyOf;
import org.exolab.adaptx.xslt.EmptyXSLObject;
import org.exolab.adaptx.xslt.Id;
import org.exolab.adaptx.xslt.Param;
import org.exolab.adaptx.xslt.ParamVariable;
import org.exolab.adaptx.xslt.Selection;
import org.exolab.adaptx.xslt.TemplateRule;
import org.exolab.adaptx.xslt.ValueOf;
import org.exolab.adaptx.xslt.Variable;
import org.exolab.adaptx.xslt.XSLCData;
import org.exolab.adaptx.xslt.XSLCallTemplate;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLIf;
import org.exolab.adaptx.xslt.XSLImport;
import org.exolab.adaptx.xslt.XSLNumber;
import org.exolab.adaptx.xslt.XSLObject;
import org.exolab.adaptx.xslt.XSLOtherwise;
import org.exolab.adaptx.xslt.XSLOutput;
import org.exolab.adaptx.xslt.XSLScript;
import org.exolab.adaptx.xslt.XSLSort;
import org.exolab.adaptx.xslt.XSLTReader;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.XSLText;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class StylesheetHandler
extends ErrorObserverAdapter
implements DocumentHandler {
    private static AttributeListWrapper _defaultAtts = new AttributeListWrapper(null);
    private int _depth = 0;
    private Locator _locator = null;
    private QuickStack _objects = null;
    private static final Hashtable _functionsTypeMap = StylesheetHandler.createFunctionMapping();
    private XSLTStylesheet _stylesheet = null;
    private String _xsltPrefix = null;
    private boolean _literal = false;
    private boolean _ignore = false;
    private int _ignoreDepth = 0;
    private boolean _dirty = false;
    private XSLTReader _xsltReader = null;
    private URIResolver _resolver = null;

    public StylesheetHandler() {
        this(null);
    }

    public StylesheetHandler(XSLTReader xSLTReader) {
        if (xSLTReader == null) {
            this._xsltReader = new XSLTReader();
            this._xsltReader.addErrorObserver(this);
        } else {
            this._xsltReader = xSLTReader;
            this.addErrorObserver(this._xsltReader);
        }
        this.init();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._dirty = true;
        if (this._objects.empty()) {
            return;
        }
        XSLObject xSLObject = (XSLObject)this._objects.peek();
        if (XMLUtil.isWhitespace(cArray, n, n2)) {
            switch (xSLObject.getType()) {
                case 6: 
                case 33: {
                    xSLObject.appendText(cArray, n, n2);
                    break;
                }
            }
            return;
        }
        xSLObject.appendText(cArray, n, n2);
    }

    private static Hashtable createFunctionMapping() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("text/javascript", "ECMAScript");
        hashtable.put("text/ecmascript", "ECMAScript");
        hashtable.put("text/jpython", "JPython");
        return hashtable;
    }

    public void endDocument() throws SAXException {
        this._dirty = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String string) throws SAXException {
        this._dirty = true;
        if (this._ignore) {
            --this._ignoreDepth;
            this._ignore = this._ignoreDepth != 0;
            return;
        }
        --this._depth;
        XSLObject xSLObject = (XSLObject)this._objects.pop();
        if (this._depth == 0) return;
        if (this._depth == 1 && !this._literal) {
            switch (xSLObject.getType()) {
                case 4: {
                    this._stylesheet.addAttributeSet((AttributeSet)xSLObject);
                    return;
                }
                case 26: {
                    try {
                        this._stylesheet.addParam((Param)xSLObject);
                        return;
                    }
                    catch (XSLException xSLException) {
                        String string2 = xSLException.getMessage();
                        string2 = String.valueOf(string2) + "\n -- processing without top-level param.";
                        this.handleError(string2);
                    }
                    return;
                }
                case 35: {
                    try {
                        this._stylesheet.addVariable((Variable)xSLObject);
                        return;
                    }
                    catch (XSLException xSLException) {
                        String string3 = xSLException.getMessage();
                        string3 = String.valueOf(string3) + "\n -- processing without variable.";
                        this.handleError(string3);
                    }
                    return;
                }
                case 25: {
                    this._stylesheet.appendAction(xSLObject);
                    return;
                }
                case 15: {
                    this._stylesheet.addId((Id)xSLObject);
                    return;
                }
                case 17: {
                    this.importStyle(xSLObject.getAttribute("href"));
                    return;
                }
                case 18: {
                    this.includeStyle(xSLObject.getAttribute("href"));
                    return;
                }
                case 28: 
                case 30: {
                    this._stylesheet.appendAction(xSLObject);
                    return;
                }
                case 32: {
                    try {
                        this._stylesheet.addTemplate((TemplateRule)xSLObject);
                        return;
                    }
                    catch (XSLException xSLException) {
                        String string4 = xSLException.getMessage();
                        this.handleError(string4);
                    }
                    return;
                }
                case 39: {
                    this._stylesheet.addScript((XSLScript)xSLObject);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        XSLObject xSLObject2 = (XSLObject)this._objects.peek();
        xSLObject2.appendAction(xSLObject);
    }

    public XSLTStylesheet getStylesheet() {
        return this._stylesheet;
    }

    private void handleError(String string) throws SAXException {
        this.receiveError(string, 1);
    }

    private void handleError(String string, int n) throws SAXException {
        if (n == 0) {
            throw new SAXException("fatal error: " + string);
        }
        this.receiveError(string, n);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this._dirty = true;
        if (!this._objects.empty()) {
            XSLObject xSLObject = (XSLObject)this._objects.peek();
            switch (xSLObject.getType()) {
                case 6: 
                case 33: {
                    xSLObject.appendText(cArray, n, n2);
                    break;
                }
            }
        }
    }

    private void importStyle(String string) throws SAXException {
        if (this._resolver == null) {
            this._resolver = this._xsltReader.getURIResolver();
        }
        URILocation uRILocation = null;
        try {
            uRILocation = this._resolver.resolve(string, this._stylesheet.getDocumentBase());
        }
        catch (URIException uRIException) {
            throw new SAXException(uRIException);
        }
        string = uRILocation.getAbsoluteURI();
        if (!this._stylesheet.isAllowableImport(string)) {
            String string2 = "error importing stylesheet: '" + string + "'.\n";
            string2 = String.valueOf(string2) + "The stylesheet was already directly or indirectly ";
            string2 = String.valueOf(string2) + "included.";
            this.handleError(string2);
            return;
        }
        try {
            this._stylesheet.importFrom(this._xsltReader.read(uRILocation));
        }
        catch (Exception exception) {
            String string3 = "error including stylesheet: '" + string + "'.\n";
            string3 = String.valueOf(string3) + " - " + exception.getMessage() + "\n";
            string3 = String.valueOf(string3) + " - continuing processing without the import.";
            this.handleError(string3);
        }
    }

    private void includeStyle(String string) throws SAXException {
        if (this._resolver == null) {
            this._resolver = this._xsltReader.getURIResolver();
        }
        URILocation uRILocation = null;
        try {
            uRILocation = this._resolver.resolve(string, this._stylesheet.getDocumentBase());
        }
        catch (URIException uRIException) {
            throw new SAXException(uRIException);
        }
        string = uRILocation.getAbsoluteURI();
        if (!this._stylesheet.isAllowableImport(string)) {
            String string2 = "error including stylesheet: '" + string + "'.\n";
            string2 = String.valueOf(string2) + "The stylesheet was already directly or indirectly ";
            string2 = String.valueOf(string2) + "included.";
            this.handleError(string2);
            return;
        }
        try {
            this._stylesheet.includeFrom(this._xsltReader.read(uRILocation));
        }
        catch (Exception exception) {
            String string3 = "error including stylesheet: '" + string + "'.\n";
            string3 = String.valueOf(string3) + " - " + exception.getMessage() + "\n";
            string3 = String.valueOf(string3) + " - continuing processing without the import.";
            this.handleError(string3);
        }
    }

    private void init() {
        this._depth = 0;
        this._ignore = false;
        this._ignoreDepth = 0;
        this._literal = false;
        this._objects = new QuickStack();
        this._stylesheet = new XSLTStylesheet();
        this._xsltPrefix = null;
        this._dirty = false;
        this._objects.push(this._stylesheet);
    }

    private void invalidTopLevelError(String string) {
        String string2 = "' must not appear as a top-level element, may only be a descendant of a 'template' element.";
        this.receiveError("'" + string + string2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this._dirty = true;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void setURILocation(URILocation uRILocation) {
        this._stylesheet.setURILocation(uRILocation);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._resolver = uRIResolver;
    }

    public void startDocument() throws SAXException {
        if (this._dirty) {
            this.init();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Object object;
        this._dirty = true;
        if (this._ignore) {
            ++this._ignoreDepth;
            return;
        }
        String string2 = string;
        String string3 = XMLUtil.getNameSpacePrefix(string2);
        short s = 20;
        if (attributeList == null) {
            attributeList = _defaultAtts;
        }
        if (this._depth == 0) {
            try {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._stylesheet.setAttribute(attributeList.getName(n), attributeList.getValue(n));
                    ++n;
                }
            }
            catch (XSLException xSLException) {
                this.handleError(xSLException.getMessage());
            }
        }
        if (this._xsltPrefix == null) {
            this._xsltPrefix = this._stylesheet.getXSLNSPrefix();
        }
        boolean bl = false;
        if (this._xsltPrefix != null && this._xsltPrefix.equals(string3)) {
            bl = true;
            if (string3.length() > 0) {
                string2 = string2.substring(string3.length() + 1);
            }
        } else if (this._xsltPrefix == null && string3.length() == 0) {
            bl = true;
        }
        if (bl) {
            s = XSLObject.getTypeFromName(string2);
        }
        boolean bl2 = true;
        boolean bl3 = true;
        XSLObject xSLObject = null;
        if (this._depth == 0) {
            String string4;
            bl2 = false;
            if (s != 31) {
                try {
                    object = new TemplateRule();
                    ((TemplateRule)object).setMatchAttr("/");
                    this._stylesheet.addTemplate((TemplateRule)object);
                    this._objects.push(object);
                    ++this._depth;
                    xSLObject = new XSLObject(20);
                    xSLObject.setTypeName(string2);
                    int n = 0;
                    while (n < attributeList.getLength()) {
                        string4 = attributeList.getName(n);
                        String string5 = attributeList.getValue(n);
                        if (!string4.startsWith("xmlns") || !string5.equals("http://www.w3.org/1999/XSL/Transform")) {
                            xSLObject.setAttribute(string4, string5);
                        }
                        ++n;
                    }
                    this._objects.push(xSLObject);
                    ++this._depth;
                }
                catch (XSLException xSLException) {
                    this.handleError(xSLException.getMessage());
                }
            }
            xSLObject = this._stylesheet;
            object = attributeList.getValue("version");
            if ((object == null || ((String)object).length() == 0) && this._xsltPrefix != null) {
                String string6 = String.valueOf(this._xsltPrefix) + ':' + "version";
                object = attributeList.getValue(string6);
            }
            if (object == null || ((String)object).length() == 0) {
                String string7 = null;
                string7 = this._locator != null ? this._locator.getSystemId() : "[uri unknown]";
                string4 = "error in XSLT file: " + string7;
                string4 = String.valueOf(string4) + ";\n -- " + string;
                string4 = String.valueOf(string4) + " element must have a 'version'  attribute. Please update your stylesheets  accordingly, as this will be changed to a fatal  error soon. - Assuming XSLT 1.0";
                object = "1.0";
                this.handleError(string4, 2);
            }
        } else if (this._depth == 1 && !this._literal) {
            switch (s) {
                case 4: {
                    object = attributeList.getValue("name");
                    String string8 = attributeList.getValue("use-attribute-sets");
                    xSLObject = new AttributeSet((String)object);
                    if (string8 != null) {
                        try {
                            xSLObject.setAttribute("use-attribute-sets", string8);
                        }
                        catch (XSLException xSLException) {
                            this.handleError(xSLException.getMessage());
                        }
                    }
                    bl2 = false;
                    break;
                }
                case 17: {
                    xSLObject = new XSLImport(this._stylesheet);
                    bl3 = false;
                    break;
                }
                case 15: {
                    xSLObject = new Id();
                    bl3 = false;
                    break;
                }
                case 25: {
                    xSLObject = new XSLOutput();
                    break;
                }
                case 26: {
                    xSLObject = new Param(attributeList.getValue("name"));
                    object = attributeList.getValue("select");
                    if (object != null) {
                        try {
                            xSLObject.setAttribute("select", (String)object);
                        }
                        catch (XSLException xSLException) {
                            this.handleError(xSLException.getMessage());
                        }
                    }
                    bl2 = false;
                    break;
                }
                case 18: 
                case 28: 
                case 30: {
                    xSLObject = new EmptyXSLObject(s);
                    bl3 = false;
                    break;
                }
                case 32: {
                    xSLObject = new TemplateRule();
                    break;
                }
                case 35: {
                    xSLObject = new Variable(attributeList.getValue("name"));
                    object = attributeList.getValue("select");
                    if (object != null) {
                        try {
                            xSLObject.setAttribute("select", (String)object);
                        }
                        catch (XSLException xSLException) {
                            this.handleError(xSLException.getMessage());
                        }
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    xSLObject = new XSLObject(20);
                    bl3 = false;
                    bl2 = false;
                    this.invalidTopLevelError(string);
                }
            }
            this._objects.push(xSLObject);
        } else {
            switch (s) {
                case 4: 
                case 15: 
                case 17: 
                case 18: 
                case 25: 
                case 28: 
                case 30: {
                    this.topLevelOnlyError(string);
                    break;
                }
                case 0: 
                case 1: 
                case 13: {
                    xSLObject = new Selection(s);
                    break;
                }
                case 5: {
                    object = null;
                    if (attributeList != null) {
                        object = attributeList.getValue("name");
                    }
                    xSLObject = new XSLCallTemplate((String)object);
                    break;
                }
                case 6: {
                    xSLObject = new XSLCData();
                    break;
                }
                case 11: {
                    xSLObject = new CopyOf();
                    bl3 = false;
                    break;
                }
                case 16: 
                case 36: {
                    xSLObject = new XSLIf();
                    break;
                }
                case 23: {
                    xSLObject = new XSLNumber();
                    break;
                }
                case 24: {
                    xSLObject = new XSLOtherwise();
                    bl2 = false;
                    break;
                }
                case 29: {
                    xSLObject = new XSLSort();
                    bl3 = false;
                    break;
                }
                case 33: {
                    xSLObject = new XSLText();
                    break;
                }
                case 34: {
                    xSLObject = new ValueOf();
                    bl3 = false;
                    break;
                }
                case 35: {
                    xSLObject = new Variable(attributeList.getValue("name"));
                    object = attributeList.getValue("select");
                    if (object != null) {
                        try {
                            xSLObject.setAttribute("select", (String)object);
                        }
                        catch (XSLException xSLException) {
                            this.handleError(xSLException.getMessage());
                        }
                    }
                    bl2 = false;
                    break;
                }
                case 37: {
                    object = attributeList.getValue("name");
                    xSLObject = new ParamVariable((String)object);
                    String string9 = attributeList.getValue("select");
                    if (string9 != null) {
                        try {
                            xSLObject.setAttribute("select", string9);
                        }
                        catch (XSLException xSLException) {
                            this.handleError(xSLException.getMessage());
                        }
                    }
                    bl2 = false;
                    break;
                }
                case 26: {
                    xSLObject = new Param(attributeList.getValue("name"));
                    object = attributeList.getValue("select");
                    if (object != null) {
                        try {
                            xSLObject.setAttribute("select", (String)object);
                        }
                        catch (XSLException xSLException) {
                            this.handleError(xSLException.getMessage());
                        }
                    }
                    bl2 = false;
                    break;
                }
                case 38: {
                    bl3 = false;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 22: 
                case 27: {
                    xSLObject = new XSLObject(s);
                    break;
                }
                default: {
                    xSLObject = new XSLObject(20);
                    xSLObject.setTypeName(string2);
                }
            }
            this._objects.push(xSLObject);
        }
        if (bl2) {
            try {
                int n = 0;
                while (n < attributeList.getLength()) {
                    xSLObject.setAttribute(attributeList.getName(n), attributeList.getValue(n));
                    ++n;
                }
            }
            catch (XSLException xSLException) {
                this.handleError(xSLException.getMessage());
            }
        }
        ++this._depth;
    }

    private void topLevelOnlyError(String string) {
        String string2 = "' must only appear as a top-level element, a direct child of the stylesheet element.";
        this.receiveError("'" + string + string2);
    }
}

