/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.UnionExpr;

class SelectExpr
extends XPathExpression {
    private UnionExpr unionExpr = null;

    private int compareOrders(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < nArray.length && n < nArray2.length) {
            if (nArray[n] < nArray2[n]) {
                return -1;
            }
            if (nArray2[n] < nArray[n]) {
                return 1;
            }
            ++n;
        }
        if (nArray.length < nArray2.length) {
            return -1;
        }
        if (nArray2.length < nArray.length) {
            return 1;
        }
        return 0;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        return this.selectNodes(xPathContext);
    }

    public short getExprType() {
        return 9;
    }

    protected void getUnionExpr(UnionExpr unionExpr) {
        this.unionExpr = unionExpr;
    }

    private void reorder(NodeSet nodeSet, XPathContext xPathContext) {
        if (nodeSet.size() < 2) {
            return;
        }
        SortEntry[] sortEntryArray = new SortEntry[nodeSet.size()];
        int n = 0;
        while (n < nodeSet.size()) {
            SortEntry sortEntry = new SortEntry();
            sortEntry.node = nodeSet.item(n);
            sortEntry.order = xPathContext.getDocumentOrder(sortEntry.node);
            sortEntryArray[n] = sortEntry;
            ++n;
        }
        nodeSet.clear();
        int n2 = 0;
        while (n2 < sortEntryArray.length) {
            int n3 = 0;
            while (sortEntryArray[n3] == null) {
                ++n3;
            }
            int n4 = n3 + 1;
            while (n4 < sortEntryArray.length) {
                if (sortEntryArray[n4] != null && this.compareOrders(sortEntryArray[n4].order, sortEntryArray[n3].order) < 0) {
                    n3 = n4;
                }
                ++n4;
            }
            nodeSet.add(sortEntryArray[n3].node, true);
            sortEntryArray[n3] = null;
            ++n2;
        }
    }

    protected NodeSet selectNodes(XPathContext xPathContext) throws XPathException {
        if (this.unionExpr == null) {
            return xPathContext.newNodeSet();
        }
        NodeSet nodeSet = (NodeSet)this.unionExpr.evaluate(xPathContext);
        this.reorder(nodeSet, xPathContext);
        return nodeSet;
    }

    protected void setUnionExpr(UnionExpr unionExpr) {
        this.unionExpr = unionExpr;
    }

    public String toString() {
        if (this.unionExpr != null) {
            return this.unionExpr.toString();
        }
        return "";
    }

    class SortEntry {
        XPathNode node = null;
        int[] order = null;

        SortEntry() {
        }
    }
}

