/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import java.io.Serializable;
import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.engine.MatchExpression;

final class AxisIdentifier {
    AxisIdentifier() {
    }

    public static NodeSet fromAncestors(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode = xPathContext.getNode().getParentNode();
        while (xPathNode != null) {
            if (matchExpression.matches(xPathNode, xPathContext)) {
                nodeSet.add(xPathNode);
            }
            xPathNode = xPathNode.getParentNode();
        }
        return nodeSet;
    }

    public static NodeSet fromAncestorsOrSelf(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = AxisIdentifier.fromAncestors(matchExpression, xPathContext);
        XPathNode xPathNode = xPathContext.getNode();
        if (matchExpression.matches(xPathNode, xPathContext)) {
            nodeSet.add(xPathNode);
        }
        return nodeSet;
    }

    public static NodeSet fromAttributes(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        if (xPathNode.getNodeType() != 1) {
            return xPathContext.newNodeSet();
        }
        XPathNode xPathNode2 = xPathNode.getFirstAttribute();
        NodeSet nodeSet = xPathContext.newNodeSet();
        while (xPathNode2 != null) {
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        return nodeSet;
    }

    public static NodeSet fromChildren(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode = xPathContext.getNode();
        XPathNode xPathNode2 = xPathNode.getFirstChild();
        while (xPathNode2 != null) {
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        return nodeSet;
    }

    public static NodeSet fromDescendants(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        return AxisIdentifier.fromDescendants(matchExpression, xPathContext.getNode(), xPathContext);
    }

    private static NodeSet fromDescendants(MatchExpression matchExpression, XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = xPathContext.newNodeSet();
        if (xPathNode == null) {
            return nodeSet;
        }
        XPathNode xPathNode2 = xPathNode.getFirstChild();
        while (xPathNode2 != null) {
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            if (xPathNode2.hasChildNodes()) {
                NodeSet nodeSet2 = AxisIdentifier.fromDescendants(matchExpression, xPathNode2, xPathContext);
                nodeSet.add(nodeSet2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        return nodeSet;
    }

    public static NodeSet fromDescendantsOrSelf(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = AxisIdentifier.fromDescendants(matchExpression, xPathContext);
        XPathNode xPathNode = xPathContext.getNode();
        if (matchExpression.matches(xPathNode, xPathContext)) {
            nodeSet.add(xPathNode);
        }
        return nodeSet;
    }

    public static NodeSet fromFollowing(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode2 = xPathNode.getNext();
        while (xPathNode2 != null) {
            Serializable serializable;
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            if (xPathNode2.hasChildNodes()) {
                serializable = AxisIdentifier.fromDescendants(matchExpression, xPathNode2, xPathContext);
                nodeSet.add((NodeSet)serializable);
            }
            if ((serializable = xPathNode2.getNext()) == null) {
                if ((xPathNode2 = xPathNode2.getParentNode()) == null || xPathNode2.getNodeType() == 9) continue;
                xPathNode2 = xPathNode2.getNext();
                continue;
            }
            xPathNode2 = serializable;
        }
        return nodeSet;
    }

    public static NodeSet fromFollowingSiblings(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode2 = xPathNode.getNext();
        while (xPathNode2 != null) {
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        return nodeSet;
    }

    public static NodeSet fromNamespaces(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        if (xPathNode.getNodeType() != 1) {
            return xPathContext.newNodeSet();
        }
        XPathNode xPathNode2 = xPathNode.getFirstNamespace();
        NodeSet nodeSet = xPathContext.newNodeSet();
        while (xPathNode2 != null) {
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        return nodeSet;
    }

    public static NodeSet fromParent(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode().getParentNode();
        if (matchExpression.matches(xPathNode, xPathContext)) {
            return xPathContext.newNodeSet(xPathNode);
        }
        return xPathContext.newNodeSet();
    }

    public static NodeSet fromPreceding(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode = xPathContext.getNode();
        XPathNode xPathNode2 = xPathNode.getPrevious();
        if (xPathNode2 == null) {
            xPathNode2 = xPathNode.getParentNode();
        }
        while (xPathNode2 != null) {
            XPathNode xPathNode3;
            if (matchExpression.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = (xPathNode3 = xPathNode2.getPrevious()) == null ? xPathNode2.getParentNode() : xPathNode3;
        }
        return nodeSet;
    }

    public static NodeSet fromPrecedingSiblings(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode = xPathContext.getNode().getPrevious();
        while (xPathNode != null) {
            if (matchExpression.matches(xPathNode, xPathContext)) {
                nodeSet.add(xPathNode);
            }
            xPathNode = xPathNode.getPrevious();
        }
        return nodeSet;
    }

    public static NodeSet fromSelf(MatchExpression matchExpression, XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        if (matchExpression.matches(xPathNode, xPathContext)) {
            return xPathContext.newNodeSet(xPathNode);
        }
        return xPathContext.newNodeSet();
    }
}

