/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.util;

import java.lang.reflect.Array;

public class List
implements Cloneable {
    private int DEFAULT_SIZE;
    private Object[] elements;
    private int initialSize;
    private int elementCount;

    public List() {
        this.initialSize = this.DEFAULT_SIZE = 25;
        this.elementCount = 0;
        this.elements = new Object[this.DEFAULT_SIZE];
    }

    public List(int n) {
        this.initialSize = this.DEFAULT_SIZE = 25;
        this.elementCount = 0;
        this.initialSize = n;
        this.elements = new Object[n];
    }

    public boolean add(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        if (n == this.elementCount) {
            this.elements[this.elementCount++] = object;
        } else {
            this.shiftUp(n);
            this.elements[n] = object;
            ++this.elementCount;
        }
        return true;
    }

    public boolean add(Object object) {
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        this.elements[this.elementCount++] = object;
        return true;
    }

    public void clear() {
        int n = 0;
        while (n < this.elementCount) {
            this.elements[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return object;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size()) {
            return false;
        }
        int n = 0;
        while (n < this.size()) {
            block6: {
                boolean bl;
                block7: {
                    Object object2;
                    Object object3;
                    block5: {
                        object3 = this.get(n);
                        object2 = list.get(n);
                        if (object3 != null) break block5;
                        if (object2 == null) break block6;
                        bl = false;
                        break block7;
                    }
                    bl = object3.equals(object2);
                }
                if (!bl) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.elementCount) {
            Object object = this.elements[n2];
            n = 31 * n + (object == null ? 0 : object.hashCode());
            ++n2;
        }
        return n;
    }

    private void increaseSize() {
        Object[] objectArray = this.elements;
        int n = objectArray.length > 0 ? objectArray.length : 1;
        this.elements = new Object[n * 2];
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        objectArray = null;
    }

    public int indexOf(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.elementCount) {
                if (this.elements[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.elementCount) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            int n = this.elementCount - 1;
            while (n >= 0) {
                if (this.elements[n] == null) {
                    return n;
                }
                --n;
            }
        } else {
            int n = this.elementCount - 1;
            while (n >= 0) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        if (n < 0 || n > this.elementCount) {
            return null;
        }
        Object object = this.elements[n];
        this.shiftDown(n + 1);
        --this.elementCount;
        return object;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n <= -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = null;
        if (n == this.elementCount) {
            this.add(object);
        } else {
            object2 = this.elements[n];
            this.elements[n] = object;
        }
        return object2;
    }

    private void shiftDown(int n) {
        if (n <= 0 || n >= this.elementCount) {
            return;
        }
        System.arraycopy(this.elements, n, this.elements, n - 1, this.elementCount - n);
        this.elements[this.elementCount - 1] = null;
    }

    private void shiftUp(int n) {
        if (n == this.elementCount) {
            return;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        System.arraycopy(this.elements, n, this.elements, n + 1, this.elementCount - n);
    }

    public int size() {
        return this.elementCount;
    }

    public List subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        List list = new List(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            list.add(this.elements[n3]);
            ++n3;
        }
        return list;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elements, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray.length >= this.elementCount) {
            objectArray2 = objectArray;
        } else {
            Class<?> clazz = objectArray.getClass();
            objectArray2 = (Object[])Array.newInstance(clazz, this.elementCount);
        }
        System.arraycopy(this.elements, 0, objectArray2, 0, this.elementCount);
        return objectArray2;
    }

    public void trimToSize() {
        Object[] objectArray = this.elements;
        this.elements = new Object[this.elementCount];
        System.arraycopy(objectArray, 0, this.elements, 0, this.elementCount);
        objectArray = null;
    }
}

