/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "UserView.h"
#include <QListWidgetItem>

UserView::UserView(QList<user_t> users, QWidget *parent)
    :QWidget(parent)
{
    if (objectName().isEmpty())
        setObjectName(QString::fromUtf8("UserView"));
    resize(400, 300);
    gridLayout = new QGridLayout(this);
    gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
    m_infoLabel = new QLabel(this);
    m_infoLabel->setObjectName(QString::fromUtf8("m_infoLabel"));

    gridLayout->addWidget(m_infoLabel, 0, 0, 1, 1);

    m_userList = new QListWidget(this);
    m_userList->setObjectName(QString::fromUtf8("m_userList"));
    m_userList->setIconSize(QSize(48, 48));
    gridLayout->addWidget(m_userList, 1, 0, 1, 1);

    connect(m_userList, SIGNAL(itemDoubleClicked(QListWidgetItem*)), this, SLOT(itemDoubleClicked(QListWidgetItem*)));
    m_profilePics = new ProfilePictureManager(this, true);
    connect(m_profilePics, SIGNAL(pictureRecieved(unsigned long long int, QByteArray)), this,
        SLOT(pictureRecieved(unsigned long long int, QByteArray)));
    for(int i = 0; i < users.count(); i++)
    {
        user_t user = users.at(i);
        QString text = QString("%1 (%2)\n%3 Followers").arg(user.screenName).arg(user.name)
            .arg(user.followers);
        QListWidgetItem *item = new QListWidgetItem(text, m_userList);
        item->setStatusTip(QString::number(user.id));
        m_profilePics->retrievePicture(user.id, user.imageURL);
    }
}

UserView::~UserView()
{
    delete m_profilePics;
}

void UserView::setInformativeText(QString text)
{
    m_infoLabel->setText(text);
}

void UserView::updateUserList(QList<user_t> users)
{
    m_userList->clear();
    for(int i = 0; i < users.count(); i++)
    {
        user_t user = users.at(i);
        QString text = QString("%1 (%2)\n%3 Followers").arg(user.screenName).arg(user.name)
            .arg(user.followers);
        QListWidgetItem *item = new QListWidgetItem(text, m_userList);
        item->setStatusTip(QString::number(user.id));
        m_profilePics->retrievePicture(user.id, user.imageURL);
    }
}
void UserView::pictureRecieved(unsigned long long int id, QByteArray pictureData)
{
    foreach(QListWidgetItem *item, m_userList->findItems(QString("*"), Qt::MatchWrap | Qt::MatchWildcard))
    {
        if(item->statusTip().toULongLong() == id)
        {
            QPixmap map;
            map.loadFromData(pictureData);
            map = map.scaled(48, 48);
            item->setIcon(QIcon(map));
        }
    }
}

void UserView::itemDoubleClicked(QListWidgetItem *item)
{
    emit getUserInfo(item->statusTip().toULongLong());
}

void UserView::closeEvent(QCloseEvent *event)
{
    Q_UNUSED(event);
    emit closed();
}
